@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.inputs

import com.pulumi.azurenative.machinelearningcompute.inputs.ListOperationalizationClusterKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster.
 * @property resourceGroupName Name of the resource group in which the cluster is located.
 */
public data class ListOperationalizationClusterKeysPlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningcompute.inputs.ListOperationalizationClusterKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningcompute.inputs.ListOperationalizationClusterKeysPlainArgs =
        com.pulumi.azurenative.machinelearningcompute.inputs.ListOperationalizationClusterKeysPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListOperationalizationClusterKeysPlainArgs].
 */
@PulumiTagMarker
public class ListOperationalizationClusterKeysPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("elkvwihlvebssyos")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the resource group in which the cluster is located.
     */
    @JvmName("heiyfqmmlyosrmug")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListOperationalizationClusterKeysPlainArgs =
        ListOperationalizationClusterKeysPlainArgs(
            clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
