@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Instance of an Azure ML Operationalization Cluster resource.
 * @property appInsights AppInsights configuration.
 * @property clusterType The cluster type.
 * @property containerRegistry Container Registry properties.
 * @property containerService Parameters for the Azure Container Service cluster.
 * @property createdOn The date and time when the cluster was created.
 * @property description The description of the cluster.
 * @property globalServiceConfiguration Contains global configuration for the web services in the cluster.
 * @property id Specifies the resource ID.
 * @property location Specifies the location of the resource.
 * @property modifiedOn The date and time when the cluster was last modified.
 * @property name Specifies the name of the resource.
 * @property provisioningErrors List of provisioning errors reported by the resource provider.
 * @property provisioningState The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
 * @property storageAccount Storage Account properties.
 * @property tags Contains resource tags defined as key/value pairs.
 * @property type Specifies the type of the resource.
 */
public data class GetOperationalizationClusterResult(
    public val appInsights: AppInsightsPropertiesResponse? = null,
    public val clusterType: String,
    public val containerRegistry: ContainerRegistryPropertiesResponse? = null,
    public val containerService: AcsClusterPropertiesResponse? = null,
    public val createdOn: String,
    public val description: String? = null,
    public val globalServiceConfiguration: GlobalServiceConfigurationResponse? = null,
    public val id: String,
    public val location: String,
    public val modifiedOn: String,
    public val name: String,
    public val provisioningErrors: List<ErrorResponseWrapperResponse>,
    public val provisioningState: String,
    public val storageAccount: StorageAccountPropertiesResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.GetOperationalizationClusterResult):
            GetOperationalizationClusterResult = GetOperationalizationClusterResult(
            appInsights = javaType.appInsights().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.AppInsightsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterType = javaType.clusterType(),
            containerRegistry = javaType.containerRegistry().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ContainerRegistryPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerService = javaType.containerService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.AcsClusterPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdOn = javaType.createdOn(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            globalServiceConfiguration = javaType.globalServiceConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.GlobalServiceConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            modifiedOn = javaType.modifiedOn(),
            name = javaType.name(),
            provisioningErrors = javaType.provisioningErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ErrorResponseWrapperResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            storageAccount = javaType.storageAccount().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.StorageAccountPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
