@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Global configuration for services in the cluster.
 * @property autoScale The auto-scale configuration
 * @property etag The configuration ETag for updates.
 * @property serviceAuth Optional global authorization keys for all user services deployed in cluster. These are used if the service does not have auth keys.
 * @property ssl The SSL configuration properties
 */
public data class GlobalServiceConfigurationResponse(
    public val autoScale: AutoScaleConfigurationResponse? = null,
    public val etag: String? = null,
    public val serviceAuth: ServiceAuthConfigurationResponse? = null,
    public val ssl: SslConfigurationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.GlobalServiceConfigurationResponse):
            GlobalServiceConfigurationResponse = GlobalServiceConfigurationResponse(
            autoScale = javaType.autoScale().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.AutoScaleConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            serviceAuth = javaType.serviceAuth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.ServiceAuthConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ssl = javaType.ssl().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.machinelearningcompute.kotlin.outputs.SslConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
