@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Access information for the storage account.
 * @property primaryKey The primary key of the storage account.
 * @property resourceId The ARM resource ID of the storage account.
 * @property secondaryKey The secondary key of the storage account.
 */
public data class StorageAccountCredentialsResponse(
    public val primaryKey: String,
    public val resourceId: String,
    public val secondaryKey: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.StorageAccountCredentialsResponse):
            StorageAccountCredentialsResponse = StorageAccountCredentialsResponse(
            primaryKey = javaType.primaryKey(),
            resourceId = javaType.resourceId(),
            secondaryKey = javaType.secondaryKey(),
        )
    }
}
