@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningcompute.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of Storage Account.
 * @property resourceId ARM resource ID of the Azure Storage Account to store CLI specific files. If not provided one will be created. This cannot be changed once the cluster is created.
 */
public data class StorageAccountPropertiesResponse(
    public val resourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningcompute.outputs.StorageAccountPropertiesResponse):
            StorageAccountPropertiesResponse = StorageAccountPropertiesResponse(
            resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
