@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin

import com.pulumi.azurenative.machinelearningexperimentation.WorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An object that represents a machine learning team account workspace.
 * Azure REST API version: 2017-05-01-preview. Prior API version in Azure Native 1.x: 2017-05-01-preview.
 * ## Example Usage
 * ### WorkspaceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspace = new AzureNative.MachineLearningExperimentation.Workspace("workspace", new()
 *     {
 *         AccountName = "testaccount",
 *         FriendlyName = "testName",
 *         Location = "East US",
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "tagKey1", "TagValue1" },
 *         },
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningexperimentation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningexperimentation.NewWorkspace(ctx, "workspace", &machinelearningexperimentation.WorkspaceArgs{
 * 			AccountName:       pulumi.String("testaccount"),
 * 			FriendlyName:      pulumi.String("testName"),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("TagValue1"),
 * 			},
 * 			WorkspaceName: pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningexperimentation.Workspace;
 * import com.pulumi.azurenative.machinelearningexperimentation.WorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspace = new Workspace("workspace", WorkspaceArgs.builder()
 *             .accountName("testaccount")
 *             .friendlyName("testName")
 *             .location("East US")
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("tagKey1", "TagValue1"))
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningexperimentation:Workspace testworkspace /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningExperimentation/accounts/{accountName}/workspaces/{workspaceName}
 * ```
 * @property accountName The name of the machine learning team account.
 * @property description The description of this workspace.
 * @property friendlyName The friendly name for this workspace. This will be the workspace name in the arm id when the workspace object gets created
 * @property location The location of the resource. This cannot be changed after the resource is created.
 * @property resourceGroupName The name of the resource group to which the machine learning team account belongs.
 * @property tags The tags of the resource.
 * @property workspaceName The name of the machine learning team account workspace.
 */
public data class WorkspaceArgs(
    public val accountName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningexperimentation.WorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningexperimentation.WorkspaceArgs =
        com.pulumi.azurenative.machinelearningexperimentation.WorkspaceArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var description: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("fwfuftpyntfhwxap")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The description of this workspace.
     */
    @JvmName("lsixonxevmxtaddo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The friendly name for this workspace. This will be the workspace name in the arm id when the workspace object gets created
     */
    @JvmName("armyqjbvntsnhbub")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("fbxvmualgiipevqb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("unxsokuypfgewdgj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("wlglmfmiblwpvpaq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the machine learning team account workspace.
     */
    @JvmName("ulpbyfxhdubgqkqe")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name of the machine learning team account.
     */
    @JvmName("epnhsjwpbuabdvie")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The description of this workspace.
     */
    @JvmName("gyevukskttaowagb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The friendly name for this workspace. This will be the workspace name in the arm id when the workspace object gets created
     */
    @JvmName("kjmuvlfitljesflp")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value The location of the resource. This cannot be changed after the resource is created.
     */
    @JvmName("btubanvreyvpcblb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group to which the machine learning team account belongs.
     */
    @JvmName("rxjvaqjfxrukqmfk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags of the resource.
     */
    @JvmName("hdvgqlulmrndpyau")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags of the resource.
     */
    @JvmName("vsvsebtalynmobia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the machine learning team account workspace.
     */
    @JvmName("psapyuwsitsulamd")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        accountName = accountName,
        description = description,
        friendlyName = friendlyName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workspaceName = workspaceName,
    )
}
