@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningexperimentation.kotlin.inputs

import com.pulumi.azurenative.machinelearningexperimentation.inputs.StorageAccountPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of a storage account for a machine learning team account.
 * @property accessKey The access key to the storage account.
 * @property storageAccountId The fully qualified arm Id of the storage account.
 */
public data class StorageAccountPropertiesArgs(
    public val accessKey: Output<String>,
    public val storageAccountId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningexperimentation.inputs.StorageAccountPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningexperimentation.inputs.StorageAccountPropertiesArgs =
        com.pulumi.azurenative.machinelearningexperimentation.inputs.StorageAccountPropertiesArgs.builder()
            .accessKey(accessKey.applyValue({ args0 -> args0 }))
            .storageAccountId(storageAccountId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountPropertiesArgs].
 */
@PulumiTagMarker
public class StorageAccountPropertiesArgsBuilder internal constructor() {
    private var accessKey: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    /**
     * @param value The access key to the storage account.
     */
    @JvmName("qpgdiruujdjsspws")
    public suspend fun accessKey(`value`: Output<String>) {
        this.accessKey = value
    }

    /**
     * @param value The fully qualified arm Id of the storage account.
     */
    @JvmName("wcolehqrvapnsykn")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The access key to the storage account.
     */
    @JvmName("eihxhoredmadwmme")
    public suspend fun accessKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value The fully qualified arm Id of the storage account.
     */
    @JvmName("gbfjbunqclkimtjo")
    public suspend fun storageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    internal fun build(): StorageAccountPropertiesArgs = StorageAccountPropertiesArgs(
        accessKey = accessKey ?: throw PulumiNullFieldException("accessKey"),
        storageAccountId = storageAccountId ?: throw PulumiNullFieldException("storageAccountId"),
    )
}
