@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.CodeVersionResponse.Companion.toKotlin as codeVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [CodeVersion].
 */
@PulumiTagMarker
public class CodeVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CodeVersionArgs = CodeVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CodeVersionArgsBuilder.() -> Unit) {
        val builder = CodeVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CodeVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.CodeVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CodeVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Code Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var codeVersion = new AzureNative.MachineLearningServices.CodeVersion("codeVersion", new()
 *     {
 *         CodeVersionProperties = new AzureNative.MachineLearningServices.Inputs.CodeVersionArgs
 *         {
 *             CodeUri = "https://blobStorage/folderName",
 *             Description = "string",
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCodeVersion(ctx, "codeVersion", &machinelearningservices.CodeVersionArgs{
 * 			CodeVersionProperties: &machinelearningservices.CodeVersionTypeArgs{
 * 				CodeUri:     pulumi.String("https://blobStorage/folderName"),
 * 				Description: pulumi.String("string"),
 * 				IsAnonymous: pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.CodeVersion;
 * import com.pulumi.azurenative.machinelearningservices.CodeVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var codeVersion = new CodeVersion("codeVersion", CodeVersionArgs.builder()
 *             .codeVersionProperties(Map.ofEntries(
 *                 Map.entry("codeUri", "https://blobStorage/folderName"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("isAnonymous", false),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:CodeVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/codes/{name}/versions/{version}
 * ```
 */
public class CodeVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.CodeVersion,
) : KotlinCustomResource(javaResource, CodeVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val codeVersionProperties: Output<CodeVersionResponse>
        get() = javaResource.codeVersionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                codeVersionResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CodeVersionMapper : ResourceMapper<CodeVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.CodeVersion::class == javaResource::class

    override fun map(javaResource: Resource): CodeVersion = CodeVersion(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.CodeVersion,
    )
}

/**
 * @see [CodeVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CodeVersion].
 */
public suspend fun codeVersion(name: String, block: suspend CodeVersionResourceBuilder.() -> Unit):
    CodeVersion {
    val builder = CodeVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CodeVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun codeVersion(name: String): CodeVersion {
    val builder = CodeVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
