@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.ComputeArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Machine Learning compute object wrapped into ARM resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2022-01-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### Attach a Kubernetes Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.KubernetesArgs
 *         {
 *             ComputeType = "Kubernetes",
 *             Description = "some compute",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.KubernetesPropertiesArgs
 *             {
 *                 DefaultInstanceType = "defaultInstanceType",
 *                 InstanceTypes =
 *                 {
 *                     { "defaultInstanceType", new AzureNative.MachineLearningServices.Inputs.InstanceTypeSchemaArgs
 *                     {
 *                         Resources = new AzureNative.MachineLearningServices.Inputs.InstanceTypeSchemaResourcesArgs
 *                         {
 *                             Limits =
 *                             {
 *                                 { "cpu", "1" },
 *                                 { "memory", "4Gi" },
 *                                 { "nvidia.com/gpu", null },
 *                             },
 *                             Requests =
 *                             {
 *                                 { "cpu", "1" },
 *                                 { "memory", "4Gi" },
 *                                 { "nvidia.com/gpu", null },
 *                             },
 *                         },
 *                     } },
 *                 },
 *                 Namespace = "default",
 *             },
 *             ResourceId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2",
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * ComputeName: pulumi.String("compute123"),
 * Location: pulumi.String("eastus"),
 * Properties: machinelearningservices.Kubernetes{
 * ComputeType: "Kubernetes",
 * Description: "some compute",
 * Properties: machinelearningservices.KubernetesProperties{
 * DefaultInstanceType: "defaultInstanceType",
 * InstanceTypes: interface{}{
 * DefaultInstanceType: machinelearningservices.InstanceTypeSchema{
 * Resources: machinelearningservices.InstanceTypeSchemaResources{
 * Limits: interface{}{
 * Cpu: "1",
 * Memory: "4Gi",
 * Nvidia.com/gpu: nil,
 * },
 * Requests: interface{}{
 * Cpu: "1",
 * Memory: "4Gi",
 * Nvidia.com/gpu: nil,
 * },
 * },
 * },
 * },
 * Namespace: "default",
 * },
 * ResourceId: "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2",
 * },
 * ResourceGroupName: pulumi.String("testrg123"),
 * WorkspaceName: pulumi.String("workspaces123"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "Kubernetes"),
 *                 Map.entry("description", "some compute"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("defaultInstanceType", "defaultInstanceType"),
 *                     Map.entry("instanceTypes", Map.of("defaultInstanceType", Map.of("resources", Map.ofEntries(
 *                         Map.entry("limits", Map.ofEntries(
 *                             Map.entry("cpu", "1"),
 *                             Map.entry("memory", "4Gi"),
 *                             Map.entry("nvidia.com/gpu", null)
 *                         )),
 *                         Map.entry("requests", Map.ofEntries(
 *                             Map.entry("cpu", "1"),
 *                             Map.entry("memory", "4Gi"),
 *                             Map.entry("nvidia.com/gpu", null)
 *                         ))
 *                     )))),
 *                     Map.entry("namespace", "default")
 *                 )),
 *                 Map.entry("resourceId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2")
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a AML Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.AmlComputeArgs
 *         {
 *             ComputeType = "AmlCompute",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.AmlComputePropertiesArgs
 *             {
 *                 EnableNodePublicIp = true,
 *                 IsolatedNetwork = false,
 *                 OsType = "Windows",
 *                 RemoteLoginPortPublicAccess = "NotSpecified",
 *                 ScaleSettings = new AzureNative.MachineLearningServices.Inputs.ScaleSettingsArgs
 *                 {
 *                     MaxNodeCount = 1,
 *                     MinNodeCount = 0,
 *                     NodeIdleTimeBeforeScaleDown = "PT5M",
 *                 },
 *                 VirtualMachineImage = new AzureNative.MachineLearningServices.Inputs.VirtualMachineImageArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myImageGallery/images/myImageDefinition/versions/0.0.1",
 *                 },
 *                 VmPriority = "Dedicated",
 *                 VmSize = "STANDARD_NC6",
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.AmlCompute{
 * 				ComputeType: "AmlCompute",
 * 				Properties: machinelearningservices.AmlComputeProperties{
 * 					EnableNodePublicIp:          true,
 * 					IsolatedNetwork:             false,
 * 					OsType:                      "Windows",
 * 					RemoteLoginPortPublicAccess: "NotSpecified",
 * 					ScaleSettings: machinelearningservices.ScaleSettings{
 * 						MaxNodeCount:                1,
 * 						MinNodeCount:                0,
 * 						NodeIdleTimeBeforeScaleDown: "PT5M",
 * 					},
 * 					VirtualMachineImage: machinelearningservices.VirtualMachineImage{
 * 						Id: "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myImageGallery/images/myImageDefinition/versions/0.0.1",
 * 					},
 * 					VmPriority: "Dedicated",
 * 					VmSize:     "STANDARD_NC6",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "AmlCompute"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("enableNodePublicIp", true),
 *                     Map.entry("isolatedNetwork", false),
 *                     Map.entry("osType", "Windows"),
 *                     Map.entry("remoteLoginPortPublicAccess", "NotSpecified"),
 *                     Map.entry("scaleSettings", Map.ofEntries(
 *                         Map.entry("maxNodeCount", 1),
 *                         Map.entry("minNodeCount", 0),
 *                         Map.entry("nodeIdleTimeBeforeScaleDown", "PT5M")
 *                     )),
 *                     Map.entry("virtualMachineImage", Map.of("id", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myResourceGroup/providers/Microsoft.Compute/galleries/myImageGallery/images/myImageDefinition/versions/0.0.1")),
 *                     Map.entry("vmPriority", "Dedicated"),
 *                     Map.entry("vmSize", "STANDARD_NC6")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a DataFactory Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.DataFactoryArgs
 *         {
 *             ComputeType = "DataFactory",
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.DataFactory{
 * 				ComputeType: "DataFactory",
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.of("computeType", "DataFactory"))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an AKS Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.AKSArgs
 *         {
 *             ComputeType = "AKS",
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.AKS{
 * 				ComputeType: "AKS",
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.of("computeType", "AKS"))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ComputeInstance Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceArgs
 *         {
 *             ComputeType = "ComputeInstance",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstancePropertiesArgs
 *             {
 *                 ApplicationSharingPolicy = "Personal",
 *                 ComputeInstanceAuthorizationType = "personal",
 *                 CustomServices = new[]
 *                 {
 *                     new AzureNative.MachineLearningServices.Inputs.CustomServiceArgs
 *                     {
 *                         Docker = new AzureNative.MachineLearningServices.Inputs.DockerArgs
 *                         {
 *                             Privileged = true,
 *                         },
 *                         Endpoints = new[]
 *                         {
 *                             new AzureNative.MachineLearningServices.Inputs.EndpointArgs
 *                             {
 *                                 Name = "connect",
 *                                 Protocol = "http",
 *                                 Published = 8787,
 *                                 Target = 8787,
 *                             },
 *                         },
 *                         EnvironmentVariables =
 *                         {
 *                             { "test_variable", new AzureNative.MachineLearningServices.Inputs.EnvironmentVariableArgs
 *                             {
 *                                 Type = "local",
 *                                 Value = "test_value",
 *                             } },
 *                         },
 *                         Image = new AzureNative.MachineLearningServices.Inputs.ImageArgs
 *                         {
 *                             Reference = "ghcr.io/azure/rocker-rstudio-ml-verse:latest",
 *                             Type = "docker",
 *                         },
 *                         Name = "rstudio",
 *                         Volumes = new[]
 *                         {
 *                             new AzureNative.MachineLearningServices.Inputs.VolumeDefinitionArgs
 *                             {
 *                                 ReadOnly = false,
 *                                 Source = "/home/azureuser/cloudfiles",
 *                                 Target = "/home/azureuser/cloudfiles",
 *                                 Type = "bind",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 PersonalComputeInstanceSettings = new AzureNative.MachineLearningServices.Inputs.PersonalComputeInstanceSettingsArgs
 *                 {
 *                     AssignedUser = new AzureNative.MachineLearningServices.Inputs.AssignedUserArgs
 *                     {
 *                         ObjectId = "00000000-0000-0000-0000-000000000000",
 *                         TenantId = "00000000-0000-0000-0000-000000000000",
 *                     },
 *                 },
 *                 SshSettings = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceSshSettingsArgs
 *                 {
 *                     SshPublicAccess = "Disabled",
 *                 },
 *                 Subnet = new AzureNative.MachineLearningServices.Inputs.ResourceIdArgs
 *                 {
 *                     Id = "test-subnet-resource-id",
 *                 },
 *                 VmSize = "STANDARD_NC6",
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.ComputeInstance{
 * 				ComputeType: "ComputeInstance",
 * 				Properties: machinelearningservices.ComputeInstanceProperties{
 * 					ApplicationSharingPolicy:         "Personal",
 * 					ComputeInstanceAuthorizationType: "personal",
 * 					CustomServices: []machinelearningservices.CustomService{
 * 						{
 * 							Docker: {
 * 								Privileged: true,
 * 							},
 * 							Endpoints: []machinelearningservices.Endpoint{
 * 								{
 * 									Name:      "connect",
 * 									Protocol:  "http",
 * 									Published: 8787,
 * 									Target:    8787,
 * 								},
 * 							},
 * 							EnvironmentVariables: {
 * 								Test_variable: {
 * 									Type:  "local",
 * 									Value: "test_value",
 * 								},
 * 							},
 * 							Image: {
 * 								Reference: "ghcr.io/azure/rocker-rstudio-ml-verse:latest",
 * 								Type:      "docker",
 * 							},
 * 							Name: "rstudio",
 * 							Volumes: []machinelearningservices.VolumeDefinition{
 * 								{
 * 									ReadOnly: false,
 * 									Source:   "/home/azureuser/cloudfiles",
 * 									Target:   "/home/azureuser/cloudfiles",
 * 									Type:     "bind",
 * 								},
 * 							},
 * 						},
 * 					},
 * 					PersonalComputeInstanceSettings: machinelearningservices.PersonalComputeInstanceSettings{
 * 						AssignedUser: machinelearningservices.AssignedUser{
 * 							ObjectId: "00000000-0000-0000-0000-000000000000",
 * 							TenantId: "00000000-0000-0000-0000-000000000000",
 * 						},
 * 					},
 * 					SshSettings: machinelearningservices.ComputeInstanceSshSettings{
 * 						SshPublicAccess: "Disabled",
 * 					},
 * 					Subnet: machinelearningservices.ResourceId{
 * 						Id: "test-subnet-resource-id",
 * 					},
 * 					VmSize: "STANDARD_NC6",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "ComputeInstance"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("applicationSharingPolicy", "Personal"),
 *                     Map.entry("computeInstanceAuthorizationType", "personal"),
 *                     Map.entry("customServices", Map.ofEntries(
 *                         Map.entry("docker", Map.of("privileged", true)),
 *                         Map.entry("endpoints", Map.ofEntries(
 *                             Map.entry("name", "connect"),
 *                             Map.entry("protocol", "http"),
 *                             Map.entry("published", 8787),
 *                             Map.entry("target", 8787)
 *                         )),
 *                         Map.entry("environmentVariables", Map.of("test_variable", Map.ofEntries(
 *                             Map.entry("type", "local"),
 *                             Map.entry("value", "test_value")
 *                         ))),
 *                         Map.entry("image", Map.ofEntries(
 *                             Map.entry("reference", "ghcr.io/azure/rocker-rstudio-ml-verse:latest"),
 *                             Map.entry("type", "docker")
 *                         )),
 *                         Map.entry("name", "rstudio"),
 *                         Map.entry("volumes", Map.ofEntries(
 *                             Map.entry("readOnly", false),
 *                             Map.entry("source", "/home/azureuser/cloudfiles"),
 *                             Map.entry("target", "/home/azureuser/cloudfiles"),
 *                             Map.entry("type", "bind")
 *                         ))
 *                     )),
 *                     Map.entry("personalComputeInstanceSettings", Map.of("assignedUser", Map.ofEntries(
 *                         Map.entry("objectId", "00000000-0000-0000-0000-000000000000"),
 *                         Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *                     ))),
 *                     Map.entry("sshSettings", Map.of("sshPublicAccess", "Disabled")),
 *                     Map.entry("subnet", Map.of("id", "test-subnet-resource-id")),
 *                     Map.entry("vmSize", "STANDARD_NC6")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ComputeInstance Compute with Schedules
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceArgs
 *         {
 *             ComputeType = "ComputeInstance",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstancePropertiesArgs
 *             {
 *                 ApplicationSharingPolicy = "Personal",
 *                 ComputeInstanceAuthorizationType = "personal",
 *                 PersonalComputeInstanceSettings = new AzureNative.MachineLearningServices.Inputs.PersonalComputeInstanceSettingsArgs
 *                 {
 *                     AssignedUser = new AzureNative.MachineLearningServices.Inputs.AssignedUserArgs
 *                     {
 *                         ObjectId = "00000000-0000-0000-0000-000000000000",
 *                         TenantId = "00000000-0000-0000-0000-000000000000",
 *                     },
 *                 },
 *                 Schedules = new AzureNative.MachineLearningServices.Inputs.ComputeSchedulesArgs
 *                 {
 *                     ComputeStartStop = new[]
 *                     {
 *                         new AzureNative.MachineLearningServices.Inputs.ComputeStartStopScheduleArgs
 *                         {
 *                             Action = "Stop",
 *                             Cron = new AzureNative.MachineLearningServices.Inputs.CronArgs
 *                             {
 *                                 Expression = "0 18 * * *",
 *                                 StartTime = "2021-04-23T01:30:00",
 *                                 TimeZone = "Pacific Standard Time",
 *                             },
 *                             Status = "Enabled",
 *                             TriggerType = "Cron",
 *                         },
 *                     },
 *                 },
 *                 SshSettings = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceSshSettingsArgs
 *                 {
 *                     SshPublicAccess = "Disabled",
 *                 },
 *                 VmSize = "STANDARD_NC6",
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.ComputeInstance{
 * 				ComputeType: "ComputeInstance",
 * 				Properties: machinelearningservices.ComputeInstanceProperties{
 * 					ApplicationSharingPolicy:         "Personal",
 * 					ComputeInstanceAuthorizationType: "personal",
 * 					PersonalComputeInstanceSettings: machinelearningservices.PersonalComputeInstanceSettings{
 * 						AssignedUser: machinelearningservices.AssignedUser{
 * 							ObjectId: "00000000-0000-0000-0000-000000000000",
 * 							TenantId: "00000000-0000-0000-0000-000000000000",
 * 						},
 * 					},
 * 					Schedules: machinelearningservices.ComputeSchedules{
 * 						ComputeStartStop: []machinelearningservices.ComputeStartStopSchedule{
 * 							{
 * 								Action: "Stop",
 * 								Cron: {
 * 									Expression: "0 18 * * *",
 * 									StartTime:  "2021-04-23T01:30:00",
 * 									TimeZone:   "Pacific Standard Time",
 * 								},
 * 								Status:      "Enabled",
 * 								TriggerType: "Cron",
 * 							},
 * 						},
 * 					},
 * 					SshSettings: machinelearningservices.ComputeInstanceSshSettings{
 * 						SshPublicAccess: "Disabled",
 * 					},
 * 					VmSize: "STANDARD_NC6",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "ComputeInstance"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("applicationSharingPolicy", "Personal"),
 *                     Map.entry("computeInstanceAuthorizationType", "personal"),
 *                     Map.entry("personalComputeInstanceSettings", Map.of("assignedUser", Map.ofEntries(
 *                         Map.entry("objectId", "00000000-0000-0000-0000-000000000000"),
 *                         Map.entry("tenantId", "00000000-0000-0000-0000-000000000000")
 *                     ))),
 *                     Map.entry("schedules", Map.of("computeStartStop", Map.ofEntries(
 *                         Map.entry("action", "Stop"),
 *                         Map.entry("cron", Map.ofEntries(
 *                             Map.entry("expression", "0 18 * * *"),
 *                             Map.entry("startTime", "2021-04-23T01:30:00"),
 *                             Map.entry("timeZone", "Pacific Standard Time")
 *                         )),
 *                         Map.entry("status", "Enabled"),
 *                         Map.entry("triggerType", "Cron")
 *                     ))),
 *                     Map.entry("sshSettings", Map.of("sshPublicAccess", "Disabled")),
 *                     Map.entry("vmSize", "STANDARD_NC6")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Create an ComputeInstance Compute with minimal inputs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstanceArgs
 *         {
 *             ComputeType = "ComputeInstance",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.ComputeInstancePropertiesArgs
 *             {
 *                 VmSize = "STANDARD_NC6",
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.ComputeInstance{
 * 				ComputeType: "ComputeInstance",
 * 				Properties: machinelearningservices.ComputeInstanceProperties{
 * 					VmSize: "STANDARD_NC6",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "ComputeInstance"),
 *                 Map.entry("properties", Map.of("vmSize", "STANDARD_NC6"))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a AML Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.AmlComputeArgs
 *         {
 *             ComputeType = "AmlCompute",
 *             Description = "some compute",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.AmlComputePropertiesArgs
 *             {
 *                 ScaleSettings = new AzureNative.MachineLearningServices.Inputs.ScaleSettingsArgs
 *                 {
 *                     MaxNodeCount = 4,
 *                     MinNodeCount = 4,
 *                     NodeIdleTimeBeforeScaleDown = "PT5M",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.AmlCompute{
 * 				ComputeType: "AmlCompute",
 * 				Description: "some compute",
 * 				Properties: machinelearningservices.AmlComputeProperties{
 * 					ScaleSettings: machinelearningservices.ScaleSettings{
 * 						MaxNodeCount:                4,
 * 						MinNodeCount:                4,
 * 						NodeIdleTimeBeforeScaleDown: "PT5M",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "AmlCompute"),
 *                 Map.entry("description", "some compute"),
 *                 Map.entry("properties", Map.of("scaleSettings", Map.ofEntries(
 *                     Map.entry("maxNodeCount", 4),
 *                     Map.entry("minNodeCount", 4),
 *                     Map.entry("nodeIdleTimeBeforeScaleDown", "PT5M")
 *                 )))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ### Update an AKS Compute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var compute = new AzureNative.MachineLearningServices.Compute("compute", new()
 *     {
 *         ComputeName = "compute123",
 *         Location = "eastus",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.AKSArgs
 *         {
 *             ComputeType = "AKS",
 *             Description = "some compute",
 *             Properties = new AzureNative.MachineLearningServices.Inputs.AKSSchemaPropertiesArgs
 *             {
 *                 AgentCount = 4,
 *             },
 *             ResourceId = "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2",
 *         },
 *         ResourceGroupName = "testrg123",
 *         WorkspaceName = "workspaces123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewCompute(ctx, "compute", &machinelearningservices.ComputeArgs{
 * 			ComputeName: pulumi.String("compute123"),
 * 			Location:    pulumi.String("eastus"),
 * 			Properties: machinelearningservices.AKS{
 * 				ComputeType: "AKS",
 * 				Description: "some compute",
 * 				Properties: machinelearningservices.AKSSchemaProperties{
 * 					AgentCount: 4,
 * 				},
 * 				ResourceId: "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2",
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			WorkspaceName:     pulumi.String("workspaces123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Compute;
 * import com.pulumi.azurenative.machinelearningservices.ComputeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var compute = new Compute("compute", ComputeArgs.builder()
 *             .computeName("compute123")
 *             .location("eastus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("computeType", "AKS"),
 *                 Map.entry("description", "some compute"),
 *                 Map.entry("properties", Map.of("agentCount", 4)),
 *                 Map.entry("resourceId", "/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourcegroups/testrg123/providers/Microsoft.ContainerService/managedClusters/compute123-56826-c9b00420020b2")
 *             ))
 *             .resourceGroupName("testrg123")
 *             .workspaceName("workspaces123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Compute compute123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/computes/{computeName}
 * ```
 * @property computeName Name of the Azure Machine Learning compute.
 * @property identity The identity of the resource.
 * @property location Specifies the location of the resource.
 * @property properties Compute properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The sku of the workspace.
 * @property tags Contains resource tags defined as key/value pairs.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class ComputeArgs(
    public val computeName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.ComputeArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.ComputeArgs =
        com.pulumi.azurenative.machinelearningservices.ComputeArgs.builder()
            .computeName(computeName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ComputeArgs].
 */
@PulumiTagMarker
public class ComputeArgsBuilder internal constructor() {
    private var computeName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Name of the Azure Machine Learning compute.
     */
    @JvmName("hbdtrmhmscnyvpho")
    public suspend fun computeName(`value`: Output<String>) {
        this.computeName = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("broyfebmktjogsti")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("ibqnkxkylmylofbr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Compute properties
     */
    @JvmName("cdldppoxbtuuwhdw")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fsavpnvkkytbbcpr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The sku of the workspace.
     */
    @JvmName("jcfnjqwjamyvnksg")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("ewamsipinwsneeih")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("wfnwlqjwmexsjjke")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Name of the Azure Machine Learning compute.
     */
    @JvmName("cwuocehvwvomnxsu")
    public suspend fun computeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeName = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("tsccjdujvxckjgnd")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("kactelfvtbytoffk")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("bhtplrtirwartuno")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Compute properties
     */
    @JvmName("tjtlwkguujulnhnt")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qluobonyamqwqrpb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The sku of the workspace.
     */
    @JvmName("upqpsmqodxpovfqb")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The sku of the workspace.
     */
    @JvmName("mwduplipuycnqldc")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("oqpfwldqfdxwuqhs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Contains resource tags defined as key/value pairs.
     */
    @JvmName("celjcsiapoeetjtj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("alcexxirigrdlkaj")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): ComputeArgs = ComputeArgs(
        computeName = computeName,
        identity = identity,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        workspaceName = workspaceName,
    )
}
