@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.DatastoreArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate datastore (Azure Data Lake Gen1 w/ ServicePrincipal).
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.MachineLearningServices.Datastore("datastore", new()
 *     {
 *         DatastoreProperties = new AzureNative.MachineLearningServices.Inputs.AzureDataLakeGen1DatastoreArgs
 *         {
 *             Credentials = new AzureNative.MachineLearningServices.Inputs.ServicePrincipalDatastoreCredentialsArgs
 *             {
 *                 AuthorityUrl = "string",
 *                 ClientId = "00000000-1111-2222-3333-444444444444",
 *                 CredentialsType = "ServicePrincipal",
 *                 ResourceUrl = "string",
 *                 Secrets = new AzureNative.MachineLearningServices.Inputs.ServicePrincipalDatastoreSecretsArgs
 *                 {
 *                     ClientSecret = "string",
 *                     SecretsType = "ServicePrincipal",
 *                 },
 *                 TenantId = "00000000-1111-2222-3333-444444444444",
 *             },
 *             DatastoreType = "AzureDataLakeGen1",
 *             Description = "string",
 *             StoreName = "string",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         SkipValidation = false,
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDatastore(ctx, "datastore", &machinelearningservices.DatastoreArgs{
 * 			DatastoreProperties: machinelearningservices.AzureDataLakeGen1Datastore{
 * 				Credentials: machinelearningservices.ServicePrincipalDatastoreCredentials{
 * 					AuthorityUrl:    "string",
 * 					ClientId:        "00000000-1111-2222-3333-444444444444",
 * 					CredentialsType: "ServicePrincipal",
 * 					ResourceUrl:     "string",
 * 					Secrets: machinelearningservices.ServicePrincipalDatastoreSecrets{
 * 						ClientSecret: "string",
 * 						SecretsType:  "ServicePrincipal",
 * 					},
 * 					TenantId: "00000000-1111-2222-3333-444444444444",
 * 				},
 * 				DatastoreType: "AzureDataLakeGen1",
 * 				Description:   "string",
 * 				StoreName:     "string",
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Datastore;
 * import com.pulumi.azurenative.machinelearningservices.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .datastoreProperties(Map.ofEntries(
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("authorityUrl", "string"),
 *                     Map.entry("clientId", "00000000-1111-2222-3333-444444444444"),
 *                     Map.entry("credentialsType", "ServicePrincipal"),
 *                     Map.entry("resourceUrl", "string"),
 *                     Map.entry("secrets", Map.ofEntries(
 *                         Map.entry("clientSecret", "string"),
 *                         Map.entry("secretsType", "ServicePrincipal")
 *                     )),
 *                     Map.entry("tenantId", "00000000-1111-2222-3333-444444444444")
 *                 )),
 *                 Map.entry("datastoreType", "AzureDataLakeGen1"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("storeName", "string"),
 *                 Map.entry("tags", AzureBlobDatastoreArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .skipValidation(false)
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate datastore (Azure Data Lake Gen2 w/ Service Principal).
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.MachineLearningServices.Datastore("datastore", new()
 *     {
 *         DatastoreProperties = new AzureNative.MachineLearningServices.Inputs.AzureDataLakeGen2DatastoreArgs
 *         {
 *             AccountName = "string",
 *             Credentials = new AzureNative.MachineLearningServices.Inputs.ServicePrincipalDatastoreCredentialsArgs
 *             {
 *                 AuthorityUrl = "string",
 *                 ClientId = "00000000-1111-2222-3333-444444444444",
 *                 CredentialsType = "ServicePrincipal",
 *                 ResourceUrl = "string",
 *                 Secrets = new AzureNative.MachineLearningServices.Inputs.ServicePrincipalDatastoreSecretsArgs
 *                 {
 *                     ClientSecret = "string",
 *                     SecretsType = "ServicePrincipal",
 *                 },
 *                 TenantId = "00000000-1111-2222-3333-444444444444",
 *             },
 *             DatastoreType = "AzureDataLakeGen2",
 *             Description = "string",
 *             Endpoint = "string",
 *             Filesystem = "string",
 *             Protocol = "string",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         SkipValidation = false,
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDatastore(ctx, "datastore", &machinelearningservices.DatastoreArgs{
 * 			DatastoreProperties: machinelearningservices.AzureDataLakeGen2Datastore{
 * 				AccountName: "string",
 * 				Credentials: machinelearningservices.ServicePrincipalDatastoreCredentials{
 * 					AuthorityUrl:    "string",
 * 					ClientId:        "00000000-1111-2222-3333-444444444444",
 * 					CredentialsType: "ServicePrincipal",
 * 					ResourceUrl:     "string",
 * 					Secrets: machinelearningservices.ServicePrincipalDatastoreSecrets{
 * 						ClientSecret: "string",
 * 						SecretsType:  "ServicePrincipal",
 * 					},
 * 					TenantId: "00000000-1111-2222-3333-444444444444",
 * 				},
 * 				DatastoreType: "AzureDataLakeGen2",
 * 				Description:   "string",
 * 				Endpoint:      "string",
 * 				Filesystem:    "string",
 * 				Protocol:      "string",
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Datastore;
 * import com.pulumi.azurenative.machinelearningservices.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .datastoreProperties(Map.ofEntries(
 *                 Map.entry("accountName", "string"),
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("authorityUrl", "string"),
 *                     Map.entry("clientId", "00000000-1111-2222-3333-444444444444"),
 *                     Map.entry("credentialsType", "ServicePrincipal"),
 *                     Map.entry("resourceUrl", "string"),
 *                     Map.entry("secrets", Map.ofEntries(
 *                         Map.entry("clientSecret", "string"),
 *                         Map.entry("secretsType", "ServicePrincipal")
 *                     )),
 *                     Map.entry("tenantId", "00000000-1111-2222-3333-444444444444")
 *                 )),
 *                 Map.entry("datastoreType", "AzureDataLakeGen2"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("endpoint", "string"),
 *                 Map.entry("filesystem", "string"),
 *                 Map.entry("protocol", "string"),
 *                 Map.entry("tags", AzureBlobDatastoreArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .skipValidation(false)
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate datastore (Azure File store w/ AccountKey).
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.MachineLearningServices.Datastore("datastore", new()
 *     {
 *         DatastoreProperties = new AzureNative.MachineLearningServices.Inputs.AzureFileDatastoreArgs
 *         {
 *             AccountName = "string",
 *             Credentials = new AzureNative.MachineLearningServices.Inputs.AccountKeyDatastoreCredentialsArgs
 *             {
 *                 CredentialsType = "AccountKey",
 *                 Secrets = new AzureNative.MachineLearningServices.Inputs.AccountKeyDatastoreSecretsArgs
 *                 {
 *                     Key = "string",
 *                     SecretsType = "AccountKey",
 *                 },
 *             },
 *             DatastoreType = "AzureFile",
 *             Description = "string",
 *             Endpoint = "string",
 *             FileShareName = "string",
 *             Protocol = "string",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         SkipValidation = false,
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDatastore(ctx, "datastore", &machinelearningservices.DatastoreArgs{
 * 			DatastoreProperties: machinelearningservices.AzureFileDatastore{
 * 				AccountName: "string",
 * 				Credentials: machinelearningservices.AccountKeyDatastoreCredentials{
 * 					CredentialsType: "AccountKey",
 * 					Secrets: machinelearningservices.AccountKeyDatastoreSecrets{
 * 						Key:         "string",
 * 						SecretsType: "AccountKey",
 * 					},
 * 				},
 * 				DatastoreType: "AzureFile",
 * 				Description:   "string",
 * 				Endpoint:      "string",
 * 				FileShareName: "string",
 * 				Protocol:      "string",
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Datastore;
 * import com.pulumi.azurenative.machinelearningservices.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .datastoreProperties(Map.ofEntries(
 *                 Map.entry("accountName", "string"),
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("credentialsType", "AccountKey"),
 *                     Map.entry("secrets", Map.ofEntries(
 *                         Map.entry("key", "string"),
 *                         Map.entry("secretsType", "AccountKey")
 *                     ))
 *                 )),
 *                 Map.entry("datastoreType", "AzureFile"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("endpoint", "string"),
 *                 Map.entry("fileShareName", "string"),
 *                 Map.entry("protocol", "string"),
 *                 Map.entry("tags", AzureBlobDatastoreArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .skipValidation(false)
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate datastore (AzureBlob w/ AccountKey).
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var datastore = new AzureNative.MachineLearningServices.Datastore("datastore", new()
 *     {
 *         DatastoreProperties = new AzureNative.MachineLearningServices.Inputs.AzureBlobDatastoreArgs
 *         {
 *             AccountName = "string",
 *             ContainerName = "string",
 *             Credentials = new AzureNative.MachineLearningServices.Inputs.AccountKeyDatastoreCredentialsArgs
 *             {
 *                 CredentialsType = "AccountKey",
 *                 Secrets = new AzureNative.MachineLearningServices.Inputs.AccountKeyDatastoreSecretsArgs
 *                 {
 *                     Key = "string",
 *                     SecretsType = "AccountKey",
 *                 },
 *             },
 *             DatastoreType = "AzureBlob",
 *             Description = "string",
 *             Endpoint = "core.windows.net",
 *             Protocol = "https",
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         SkipValidation = false,
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewDatastore(ctx, "datastore", &machinelearningservices.DatastoreArgs{
 * 			DatastoreProperties: machinelearningservices.AzureBlobDatastore{
 * 				AccountName:   "string",
 * 				ContainerName: "string",
 * 				Credentials: machinelearningservices.AccountKeyDatastoreCredentials{
 * 					CredentialsType: "AccountKey",
 * 					Secrets: machinelearningservices.AccountKeyDatastoreSecrets{
 * 						Key:         "string",
 * 						SecretsType: "AccountKey",
 * 					},
 * 				},
 * 				DatastoreType: "AzureBlob",
 * 				Description:   "string",
 * 				Endpoint:      "core.windows.net",
 * 				Protocol:      "https",
 * 				Tags: map[string]interface{}{
 * 					"string": "string",
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Datastore;
 * import com.pulumi.azurenative.machinelearningservices.DatastoreArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var datastore = new Datastore("datastore", DatastoreArgs.builder()
 *             .datastoreProperties(Map.ofEntries(
 *                 Map.entry("accountName", "string"),
 *                 Map.entry("containerName", "string"),
 *                 Map.entry("credentials", Map.ofEntries(
 *                     Map.entry("credentialsType", "AccountKey"),
 *                     Map.entry("secrets", Map.ofEntries(
 *                         Map.entry("key", "string"),
 *                         Map.entry("secretsType", "AccountKey")
 *                     ))
 *                 )),
 *                 Map.entry("datastoreType", "AzureBlob"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("endpoint", "core.windows.net"),
 *                 Map.entry("protocol", "https"),
 *                 Map.entry("tags", AzureBlobDatastoreArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .skipValidation(false)
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Datastore string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/datastores/{name}
 * ```
 * @property datastoreProperties [Required] Additional attributes of the entity.
 * @property name Datastore name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skipValidation Flag to skip validation.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class DatastoreArgs(
    public val datastoreProperties: Output<Any>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val skipValidation: Output<Boolean>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.DatastoreArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.DatastoreArgs =
        com.pulumi.azurenative.machinelearningservices.DatastoreArgs.builder()
            .datastoreProperties(datastoreProperties?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .skipValidation(skipValidation?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatastoreArgs].
 */
@PulumiTagMarker
public class DatastoreArgsBuilder internal constructor() {
    private var datastoreProperties: Output<Any>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var skipValidation: Output<Boolean>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("wlaikiotxnqcdetw")
    public suspend fun datastoreProperties(`value`: Output<Any>) {
        this.datastoreProperties = value
    }

    /**
     * @param value Datastore name.
     */
    @JvmName("cdtxkrjmclglrkdk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("elqjkontpvpqtyhr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Flag to skip validation.
     */
    @JvmName("byjfaubhhuipbise")
    public suspend fun skipValidation(`value`: Output<Boolean>) {
        this.skipValidation = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("qxlxlcwybrvjnnuy")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("dnapifpelltviwdk")
    public suspend fun datastoreProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreProperties = mapped
    }

    /**
     * @param value Datastore name.
     */
    @JvmName("hqvcxjqxabkuirpw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ogifyfymmbjphaoj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Flag to skip validation.
     */
    @JvmName("hbxrjtecgufdvlix")
    public suspend fun skipValidation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipValidation = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("xpydwujoocaqbemc")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): DatastoreArgs = DatastoreArgs(
        datastoreProperties = datastoreProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        skipValidation = skipValidation,
        workspaceName = workspaceName,
    )
}
