@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentSpecificationVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentSpecificationVersionResponse.Companion.toKotlin as environmentSpecificationVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EnvironmentSpecificationVersion].
 */
@PulumiTagMarker
public class EnvironmentSpecificationVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentSpecificationVersionArgs = EnvironmentSpecificationVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentSpecificationVersionArgsBuilder.() -> Unit) {
        val builder = EnvironmentSpecificationVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EnvironmentSpecificationVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnvironmentSpecificationVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2021-03-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * ## Example Usage
 * ### CreateOrUpdate Environment Specification Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environmentSpecificationVersion = new AzureNative.MachineLearningServices.EnvironmentSpecificationVersion("environmentSpecificationVersion", new()
 *     {
 *         Name = "testEnvironment",
 *         Properties = new AzureNative.MachineLearningServices.Inputs.EnvironmentSpecificationVersionArgs
 *         {
 *             CondaFile = @"channels:
 * - defaults
 * dependencies:
 * - python=3.7.7
 * name: my-env",
 *             Description = "string",
 *             Docker = new AzureNative.MachineLearningServices.Inputs.DockerBuildArgs
 *             {
 *                 DockerSpecificationType = "Build",
 *                 Dockerfile = "FROM myimage",
 *             },
 *             Properties =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *         },
 *         ResourceGroupName = "testrg123",
 *         Version = "1",
 *         WorkspaceName = "testworkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewEnvironmentSpecificationVersion(ctx, "environmentSpecificationVersion", &machinelearningservices.EnvironmentSpecificationVersionArgs{
 * 			Name: pulumi.String("testEnvironment"),
 * 			Properties: machinelearningservices.EnvironmentSpecificationVersionResponse{
 * 				CondaFile:   pulumi.String("channels:\n- defaults\ndependencies:\n- python=3.7.7\nname: my-env"),
 * 				Description: pulumi.String("string"),
 * 				Docker: machinelearningservices.DockerBuild{
 * 					DockerSpecificationType: "Build",
 * 					Dockerfile:              "FROM myimage",
 * 				},
 * 				Properties: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			Version:           pulumi.String("1"),
 * 			WorkspaceName:     pulumi.String("testworkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersion;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environmentSpecificationVersion = new EnvironmentSpecificationVersion("environmentSpecificationVersion", EnvironmentSpecificationVersionArgs.builder()
 *             .name("testEnvironment")
 *             .properties(Map.ofEntries(
 *                 Map.entry("condaFile", """
 * channels:
 * - defaults
 * dependencies:
 * - python=3.7.7
 * name: my-env                """),
 *                 Map.entry("description", "string"),
 *                 Map.entry("docker", Map.ofEntries(
 *                     Map.entry("dockerSpecificationType", "Build"),
 *                     Map.entry("dockerfile", "FROM myimage")
 *                 )),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 )),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg123")
 *             .version("1")
 *             .workspaceName("testworkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:EnvironmentSpecificationVersion 1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/environments/{name}/versions/{version}
 * ```
 */
public class EnvironmentSpecificationVersion internal constructor(
    override val javaResource:
    com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersion,
) : KotlinCustomResource(javaResource, EnvironmentSpecificationVersionMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * [Required] Additional attributes of the entity.
     */
    public val properties: Output<EnvironmentSpecificationVersionResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                environmentSpecificationVersionResponseToKotlin(args0)
            })
        })

    /**
     * System data associated with resource provider
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnvironmentSpecificationVersionMapper :
    ResourceMapper<EnvironmentSpecificationVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersion::class == javaResource::class

    override fun map(javaResource: Resource): EnvironmentSpecificationVersion =
        EnvironmentSpecificationVersion(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.EnvironmentSpecificationVersion,
        )
}

/**
 * @see [EnvironmentSpecificationVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnvironmentSpecificationVersion].
 */
public suspend fun environmentSpecificationVersion(
    name: String,
    block: suspend EnvironmentSpecificationVersionResourceBuilder.() -> Unit,
):
    EnvironmentSpecificationVersion {
    val builder = EnvironmentSpecificationVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnvironmentSpecificationVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environmentSpecificationVersion(name: String): EnvironmentSpecificationVersion {
    val builder = EnvironmentSpecificationVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
