@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.EnvironmentVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Environment Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var environmentVersion = new AzureNative.MachineLearningServices.EnvironmentVersion("environmentVersion", new()
 *     {
 *         EnvironmentVersionProperties = new AzureNative.MachineLearningServices.Inputs.EnvironmentVersionArgs
 *         {
 *             Build = new AzureNative.MachineLearningServices.Inputs.BuildContextArgs
 *             {
 *                 ContextUri = "https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/",
 *                 DockerfilePath = "prod/Dockerfile",
 *             },
 *             CondaFile = "string",
 *             Description = "string",
 *             Image = "docker.io/tensorflow/serving:latest",
 *             InferenceConfig = new AzureNative.MachineLearningServices.Inputs.InferenceContainerPropertiesArgs
 *             {
 *                 LivenessRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *                 ReadinessRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *                 ScoringRoute = new AzureNative.MachineLearningServices.Inputs.RouteArgs
 *                 {
 *                     Path = "string",
 *                     Port = 1,
 *                 },
 *             },
 *             IsAnonymous = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewEnvironmentVersion(ctx, "environmentVersion", &machinelearningservices.EnvironmentVersionArgs{
 * EnvironmentVersionProperties: machinelearningservices.EnvironmentVersionResponse{
 * Build: &machinelearningservices.BuildContextArgs{
 * ContextUri: pulumi.String("https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/"),
 * DockerfilePath: pulumi.String("prod/Dockerfile"),
 * },
 * CondaFile: pulumi.String("string"),
 * Description: pulumi.String("string"),
 * Image: pulumi.String("docker.io/tensorflow/serving:latest"),
 * InferenceConfig: interface{}{
 * LivenessRoute: &machinelearningservices.RouteArgs{
 * Path: pulumi.String("string"),
 * Port: pulumi.Int(1),
 * },
 * ReadinessRoute: &machinelearningservices.RouteArgs{
 * Path: pulumi.String("string"),
 * Port: pulumi.Int(1),
 * },
 * ScoringRoute: &machinelearningservices.RouteArgs{
 * Path: pulumi.String("string"),
 * Port: pulumi.Int(1),
 * },
 * },
 * IsAnonymous: pulumi.Bool(false),
 * Properties: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * Tags: pulumi.StringMap{
 * "string": pulumi.String("string"),
 * },
 * },
 * Name: pulumi.String("string"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * Version: pulumi.String("string"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentVersion;
 * import com.pulumi.azurenative.machinelearningservices.EnvironmentVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var environmentVersion = new EnvironmentVersion("environmentVersion", EnvironmentVersionArgs.builder()
 *             .environmentVersionProperties(Map.ofEntries(
 *                 Map.entry("build", Map.ofEntries(
 *                     Map.entry("contextUri", "https://storage-account.blob.core.windows.net/azureml/DockerBuildContext/95ddede6b9b8c4e90472db3acd0a8d28/"),
 *                     Map.entry("dockerfilePath", "prod/Dockerfile")
 *                 )),
 *                 Map.entry("condaFile", "string"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("image", "docker.io/tensorflow/serving:latest"),
 *                 Map.entry("inferenceConfig", Map.ofEntries(
 *                     Map.entry("livenessRoute", Map.ofEntries(
 *                         Map.entry("path", "string"),
 *                         Map.entry("port", 1)
 *                     )),
 *                     Map.entry("readinessRoute", Map.ofEntries(
 *                         Map.entry("path", "string"),
 *                         Map.entry("port", 1)
 *                     )),
 *                     Map.entry("scoringRoute", Map.ofEntries(
 *                         Map.entry("path", "string"),
 *                         Map.entry("port", 1)
 *                     ))
 *                 )),
 *                 Map.entry("isAnonymous", false),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:EnvironmentVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/environments/{name}/versions/{version}
 * ```
 * @property environmentVersionProperties [Required] Additional attributes of the entity.
 * @property name Name of EnvironmentVersion. This is case-sensitive.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version of EnvironmentVersion.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class EnvironmentVersionArgs(
    public val environmentVersionProperties:
    Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentVersionArgs>? =
        null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.EnvironmentVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.EnvironmentVersionArgs =
        com.pulumi.azurenative.machinelearningservices.EnvironmentVersionArgs.builder()
            .environmentVersionProperties(
                environmentVersionProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentVersionArgs].
 */
@PulumiTagMarker
public class EnvironmentVersionArgsBuilder internal constructor() {
    private var environmentVersionProperties:
        Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentVersionArgs>? =
        null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("dgceqglysutkooav")
    public suspend
    fun environmentVersionProperties(`value`: Output<com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentVersionArgs>) {
        this.environmentVersionProperties = value
    }

    /**
     * @param value Name of EnvironmentVersion. This is case-sensitive.
     */
    @JvmName("wrusuygtfolepjgg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ovjjceihvgxoxbme")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version of EnvironmentVersion.
     */
    @JvmName("rnimjxwgdbesvjmf")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("rkcnbkyidybwdicj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("gxlfrygoexjareip")
    public suspend
    fun environmentVersionProperties(`value`: com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVersionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("uadycvklupcnvgfg")
    public suspend
    fun environmentVersionProperties(argument: suspend com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentVersionArgsBuilder.() -> Unit) {
        val toBeMapped =
            com.pulumi.azurenative.machinelearningservices.kotlin.inputs.EnvironmentVersionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.environmentVersionProperties = mapped
    }

    /**
     * @param value Name of EnvironmentVersion. This is case-sensitive.
     */
    @JvmName("vvqdprsjlaqjamtl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cpyrdkeliehhanqv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version of EnvironmentVersion.
     */
    @JvmName("gwivwpuhitsucxhu")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("twicgujnsdbexvff")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): EnvironmentVersionArgs = EnvironmentVersionArgs(
        environmentVersionProperties = environmentVersionProperties,
        name = name,
        resourceGroupName = resourceGroupName,
        version = version,
        workspaceName = workspaceName,
    )
}
