@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.JobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate AutoML Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.MachineLearningServices.Job("job", new()
 *     {
 *         Id = "string",
 *         JobBaseProperties = new AzureNative.MachineLearningServices.Inputs.AutoMLJobArgs
 *         {
 *             ComputeId = "string",
 *             Description = "string",
 *             DisplayName = "string",
 *             EnvironmentId = "string",
 *             EnvironmentVariables =
 *             {
 *                 { "string", "string" },
 *             },
 *             ExperimentName = "string",
 *             Identity = new AzureNative.MachineLearningServices.Inputs.AmlTokenArgs
 *             {
 *                 IdentityType = "AMLToken",
 *             },
 *             IsArchived = false,
 *             JobType = "AutoML",
 *             Outputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.UriFileJobOutputArgs
 *                 {
 *                     Description = "string",
 *                     JobOutputType = "uri_file",
 *                     Mode = "ReadWriteMount",
 *                     Uri = "string",
 *                 } },
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Resources = new AzureNative.MachineLearningServices.Inputs.JobResourceConfigurationArgs
 *             {
 *                 InstanceCount = 1,
 *                 InstanceType = "string",
 *                 Properties =
 *                 {
 *                     { "string",
 *                     {
 *                         { "9bec0ab0-c62f-4fa9-a97c-7b24bbcc90ad", null },
 *                     } },
 *                 },
 *             },
 *             Services =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.JobServiceArgs
 *                 {
 *                     Endpoint = "string",
 *                     JobServiceType = "string",
 *                     Port = 1,
 *                     Properties =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *             TaskDetails = new AzureNative.MachineLearningServices.Inputs.ImageClassificationArgs
 *             {
 *                 LimitSettings = new AzureNative.MachineLearningServices.Inputs.ImageLimitSettingsArgs
 *                 {
 *                     MaxTrials = 2,
 *                 },
 *                 ModelSettings = new AzureNative.MachineLearningServices.Inputs.ImageModelSettingsClassificationArgs
 *                 {
 *                     ValidationCropSize = 2,
 *                 },
 *                 SearchSpace = new[]
 *                 {
 *                     new AzureNative.MachineLearningServices.Inputs.ImageModelDistributionSettingsClassificationArgs
 *                     {
 *                         ValidationCropSize = "choice(2, 360)",
 *                     },
 *                 },
 *                 TargetColumnName = "string",
 *                 TaskType = "ImageClassification",
 *                 TrainingData = new AzureNative.MachineLearningServices.Inputs.MLTableJobInputArgs
 *                 {
 *                     JobInputType = "mltable",
 *                     Uri = "string",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewJob(ctx, "job", &machinelearningservices.JobArgs{
 * Id: pulumi.String("string"),
 * JobBaseProperties: machinelearningservices.AutoMLJob{
 * ComputeId: "string",
 * Description: "string",
 * DisplayName: "string",
 * EnvironmentId: "string",
 * EnvironmentVariables: map[string]interface{}{
 * "string": "string",
 * },
 * ExperimentName: "string",
 * Identity: machinelearningservices.AmlToken{
 * IdentityType: "AMLToken",
 * },
 * IsArchived: false,
 * JobType: "AutoML",
 * Outputs: interface{}{
 * String: machinelearningservices.UriFileJobOutput{
 * Description: "string",
 * JobOutputType: "uri_file",
 * Mode: "ReadWriteMount",
 * Uri: "string",
 * },
 * },
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * Resources: machinelearningservices.JobResourceConfiguration{
 * InstanceCount: 1,
 * InstanceType: "string",
 * Properties: map[string]interface{}{
 * "string": map[string]interface{}{
 * "9bec0ab0-c62f-4fa9-a97c-7b24bbcc90ad": nil,
 * },
 * },
 * },
 * Services: interface{}{
 * String: machinelearningservices.JobService{
 * Endpoint: "string",
 * JobServiceType: "string",
 * Port: 1,
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * },
 * Tags: map[string]interface{}{
 * "string": "string",
 * },
 * TaskDetails: machinelearningservices.ImageClassification{
 * LimitSettings: machinelearningservices.ImageLimitSettings{
 * MaxTrials: 2,
 * },
 * ModelSettings: machinelearningservices.ImageModelSettingsClassification{
 * ValidationCropSize: 2,
 * },
 * SearchSpace: []machinelearningservices.ImageModelDistributionSettingsClassification{
 * {
 * ValidationCropSize: "choice(2, 360)",
 * },
 * },
 * TargetColumnName: "string",
 * TaskType: "ImageClassification",
 * TrainingData: machinelearningservices.MLTableJobInput{
 * JobInputType: "mltable",
 * Uri: "string",
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Job;
 * import com.pulumi.azurenative.machinelearningservices.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .id("string")
 *             .jobBaseProperties(Map.ofEntries(
 *                 Map.entry("computeId", "string"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("displayName", "string"),
 *                 Map.entry("environmentId", "string"),
 *                 Map.entry("environmentVariables", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build()),
 *                 Map.entry("experimentName", "string"),
 *                 Map.entry("identity", Map.of("identityType", "AMLToken")),
 *                 Map.entry("isArchived", false),
 *                 Map.entry("jobType", "AutoML"),
 *                 Map.entry("outputs", Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobOutputType", "uri_file"),
 *                     Map.entry("mode", "ReadWriteMount"),
 *                     Map.entry("uri", "string")
 *                 ))),
 *                 Map.entry("properties", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build()),
 *                 Map.entry("resources", Map.ofEntries(
 *                     Map.entry("instanceCount", 1),
 *                     Map.entry("instanceType", "string"),
 *                     Map.entry("properties", AutoMLJobArgs.builder()
 *                         .string(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                 )),
 *                 Map.entry("services", Map.of("string", Map.ofEntries(
 *                     Map.entry("endpoint", "string"),
 *                     Map.entry("jobServiceType", "string"),
 *                     Map.entry("port", 1),
 *                     Map.entry("properties", AutoMLJobArgs.builder()
 *                         .string("string")
 *                         .build())
 *                 ))),
 *                 Map.entry("tags", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build()),
 *                 Map.entry("taskDetails", Map.ofEntries(
 *                     Map.entry("limitSettings", Map.of("maxTrials", 2)),
 *                     Map.entry("modelSettings", Map.of("validationCropSize", 2)),
 *                     Map.entry("searchSpace", Map.of("validationCropSize", "choice(2, 360)")),
 *                     Map.entry("targetColumnName", "string"),
 *                     Map.entry("taskType", "ImageClassification"),
 *                     Map.entry("trainingData", Map.ofEntries(
 *                         Map.entry("jobInputType", "mltable"),
 *                         Map.entry("uri", "string")
 *                     ))
 *                 ))
 *             ))
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate Command Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.MachineLearningServices.Job("job", new()
 *     {
 *         Id = "string",
 *         JobBaseProperties = new AzureNative.MachineLearningServices.Inputs.CommandJobArgs
 *         {
 *             CodeId = "string",
 *             Command = "string",
 *             ComputeId = "string",
 *             Description = "string",
 *             DisplayName = "string",
 *             Distribution = new AzureNative.MachineLearningServices.Inputs.TensorFlowArgs
 *             {
 *                 DistributionType = "TensorFlow",
 *                 ParameterServerCount = 1,
 *                 WorkerCount = 1,
 *             },
 *             EnvironmentId = "string",
 *             EnvironmentVariables =
 *             {
 *                 { "string", "string" },
 *             },
 *             ExperimentName = "string",
 *             Identity = new AzureNative.MachineLearningServices.Inputs.AmlTokenArgs
 *             {
 *                 IdentityType = "AMLToken",
 *             },
 *             Inputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.LiteralJobInputArgs
 *                 {
 *                     Description = "string",
 *                     JobInputType = "literal",
 *                     Value = "string",
 *                 } },
 *             },
 *             JobType = "Command",
 *             Limits = new AzureNative.MachineLearningServices.Inputs.CommandJobLimitsArgs
 *             {
 *                 JobLimitsType = "Command",
 *                 Timeout = "PT5M",
 *             },
 *             Outputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.UriFileJobOutputArgs
 *                 {
 *                     Description = "string",
 *                     JobOutputType = "uri_file",
 *                     Mode = "ReadWriteMount",
 *                     Uri = "string",
 *                 } },
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Resources = new AzureNative.MachineLearningServices.Inputs.JobResourceConfigurationArgs
 *             {
 *                 InstanceCount = 1,
 *                 InstanceType = "string",
 *                 Properties =
 *                 {
 *                     { "string",
 *                     {
 *                         { "e6b6493e-7d5e-4db3-be1e-306ec641327e", null },
 *                     } },
 *                 },
 *             },
 *             Services =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.JobServiceArgs
 *                 {
 *                     Endpoint = "string",
 *                     JobServiceType = "string",
 *                     Port = 1,
 *                     Properties =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewJob(ctx, "job", &machinelearningservices.JobArgs{
 * Id: pulumi.String("string"),
 * JobBaseProperties: machinelearningservices.CommandJob{
 * CodeId: "string",
 * Command: "string",
 * ComputeId: "string",
 * Description: "string",
 * DisplayName: "string",
 * Distribution: machinelearningservices.TensorFlow{
 * DistributionType: "TensorFlow",
 * ParameterServerCount: 1,
 * WorkerCount: 1,
 * },
 * EnvironmentId: "string",
 * EnvironmentVariables: map[string]interface{}{
 * "string": "string",
 * },
 * ExperimentName: "string",
 * Identity: machinelearningservices.AmlToken{
 * IdentityType: "AMLToken",
 * },
 * Inputs: interface{}{
 * String: machinelearningservices.LiteralJobInput{
 * Description: "string",
 * JobInputType: "literal",
 * Value: "string",
 * },
 * },
 * JobType: "Command",
 * Limits: machinelearningservices.CommandJobLimits{
 * JobLimitsType: "Command",
 * Timeout: "PT5M",
 * },
 * Outputs: interface{}{
 * String: machinelearningservices.UriFileJobOutput{
 * Description: "string",
 * JobOutputType: "uri_file",
 * Mode: "ReadWriteMount",
 * Uri: "string",
 * },
 * },
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * Resources: machinelearningservices.JobResourceConfiguration{
 * InstanceCount: 1,
 * InstanceType: "string",
 * Properties: map[string]interface{}{
 * "string": map[string]interface{}{
 * "e6b6493e-7d5e-4db3-be1e-306ec641327e": nil,
 * },
 * },
 * },
 * Services: interface{}{
 * String: machinelearningservices.JobService{
 * Endpoint: "string",
 * JobServiceType: "string",
 * Port: 1,
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * },
 * Tags: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Job;
 * import com.pulumi.azurenative.machinelearningservices.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .id("string")
 *             .jobBaseProperties(Map.ofEntries(
 *                 Map.entry("codeId", "string"),
 *                 Map.entry("command", "string"),
 *                 Map.entry("computeId", "string"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("displayName", "string"),
 *                 Map.entry("distribution", Map.ofEntries(
 *                     Map.entry("distributionType", "TensorFlow"),
 *                     Map.entry("parameterServerCount", 1),
 *                     Map.entry("workerCount", 1)
 *                 )),
 *                 Map.entry("environmentId", "string"),
 *                 Map.entry("environmentVariables", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build()),
 *                 Map.entry("experimentName", "string"),
 *                 Map.entry("identity", Map.of("identityType", "AMLToken")),
 *                 Map.entry("inputs", Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobInputType", "literal"),
 *                     Map.entry("value", "string")
 *                 ))),
 *                 Map.entry("jobType", "Command"),
 *                 Map.entry("limits", Map.ofEntries(
 *                     Map.entry("jobLimitsType", "Command"),
 *                     Map.entry("timeout", "PT5M")
 *                 )),
 *                 Map.entry("outputs", Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobOutputType", "uri_file"),
 *                     Map.entry("mode", "ReadWriteMount"),
 *                     Map.entry("uri", "string")
 *                 ))),
 *                 Map.entry("properties", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build()),
 *                 Map.entry("resources", Map.ofEntries(
 *                     Map.entry("instanceCount", 1),
 *                     Map.entry("instanceType", "string"),
 *                     Map.entry("properties", AutoMLJobArgs.builder()
 *                         .string(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build())
 *                 )),
 *                 Map.entry("services", Map.of("string", Map.ofEntries(
 *                     Map.entry("endpoint", "string"),
 *                     Map.entry("jobServiceType", "string"),
 *                     Map.entry("port", 1),
 *                     Map.entry("properties", AutoMLJobArgs.builder()
 *                         .string("string")
 *                         .build())
 *                 ))),
 *                 Map.entry("tags", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate Pipeline Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.MachineLearningServices.Job("job", new()
 *     {
 *         Id = "string",
 *         JobBaseProperties = new AzureNative.MachineLearningServices.Inputs.PipelineJobArgs
 *         {
 *             ComputeId = "string",
 *             Description = "string",
 *             DisplayName = "string",
 *             ExperimentName = "string",
 *             Inputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.LiteralJobInputArgs
 *                 {
 *                     Description = "string",
 *                     JobInputType = "literal",
 *                     Value = "string",
 *                 } },
 *             },
 *             JobType = "Pipeline",
 *             Outputs =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.UriFileJobOutputArgs
 *                 {
 *                     Description = "string",
 *                     JobOutputType = "uri_file",
 *                     Mode = "Upload",
 *                     Uri = "string",
 *                 } },
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Services =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.JobServiceArgs
 *                 {
 *                     Endpoint = "string",
 *                     JobServiceType = "string",
 *                     Port = 1,
 *                     Properties =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             Settings = null,
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewJob(ctx, "job", &machinelearningservices.JobArgs{
 * Id: pulumi.String("string"),
 * JobBaseProperties: machinelearningservices.PipelineJob{
 * ComputeId: "string",
 * Description: "string",
 * DisplayName: "string",
 * ExperimentName: "string",
 * Inputs: interface{}{
 * String: machinelearningservices.LiteralJobInput{
 * Description: "string",
 * JobInputType: "literal",
 * Value: "string",
 * },
 * },
 * JobType: "Pipeline",
 * Outputs: interface{}{
 * String: machinelearningservices.UriFileJobOutput{
 * Description: "string",
 * JobOutputType: "uri_file",
 * Mode: "Upload",
 * Uri: "string",
 * },
 * },
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * Services: interface{}{
 * String: machinelearningservices.JobService{
 * Endpoint: "string",
 * JobServiceType: "string",
 * Port: 1,
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * },
 * Settings: nil,
 * Tags: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Job;
 * import com.pulumi.azurenative.machinelearningservices.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .id("string")
 *             .jobBaseProperties(Map.ofEntries(
 *                 Map.entry("computeId", "string"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("displayName", "string"),
 *                 Map.entry("experimentName", "string"),
 *                 Map.entry("inputs", Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobInputType", "literal"),
 *                     Map.entry("value", "string")
 *                 ))),
 *                 Map.entry("jobType", "Pipeline"),
 *                 Map.entry("outputs", Map.of("string", Map.ofEntries(
 *                     Map.entry("description", "string"),
 *                     Map.entry("jobOutputType", "uri_file"),
 *                     Map.entry("mode", "Upload"),
 *                     Map.entry("uri", "string")
 *                 ))),
 *                 Map.entry("properties", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build()),
 *                 Map.entry("services", Map.of("string", Map.ofEntries(
 *                     Map.entry("endpoint", "string"),
 *                     Map.entry("jobServiceType", "string"),
 *                     Map.entry("port", 1),
 *                     Map.entry("properties", AutoMLJobArgs.builder()
 *                         .string("string")
 *                         .build())
 *                 ))),
 *                 Map.entry("settings", ),
 *                 Map.entry("tags", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build())
 *             ))
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ### CreateOrUpdate Sweep Job.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.MachineLearningServices.Job("job", new()
 *     {
 *         Id = "string",
 *         JobBaseProperties = new AzureNative.MachineLearningServices.Inputs.SweepJobArgs
 *         {
 *             ComputeId = "string",
 *             Description = "string",
 *             DisplayName = "string",
 *             EarlyTermination = new AzureNative.MachineLearningServices.Inputs.MedianStoppingPolicyArgs
 *             {
 *                 DelayEvaluation = 1,
 *                 EvaluationInterval = 1,
 *                 PolicyType = "MedianStopping",
 *             },
 *             ExperimentName = "string",
 *             JobType = "Sweep",
 *             Limits = new AzureNative.MachineLearningServices.Inputs.SweepJobLimitsArgs
 *             {
 *                 JobLimitsType = "Sweep",
 *                 MaxConcurrentTrials = 1,
 *                 MaxTotalTrials = 1,
 *                 TrialTimeout = "PT1S",
 *             },
 *             Objective = new AzureNative.MachineLearningServices.Inputs.ObjectiveArgs
 *             {
 *                 Goal = "Minimize",
 *                 PrimaryMetric = "string",
 *             },
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             SamplingAlgorithm = new AzureNative.MachineLearningServices.Inputs.GridSamplingAlgorithmArgs
 *             {
 *                 SamplingAlgorithmType = "Grid",
 *             },
 *             SearchSpace =
 *             {
 *                 { "string", null },
 *             },
 *             Services =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.JobServiceArgs
 *                 {
 *                     Endpoint = "string",
 *                     JobServiceType = "string",
 *                     Port = 1,
 *                     Properties =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *             Trial = new AzureNative.MachineLearningServices.Inputs.TrialComponentArgs
 *             {
 *                 CodeId = "string",
 *                 Command = "string",
 *                 Distribution = new AzureNative.MachineLearningServices.Inputs.MpiArgs
 *                 {
 *                     DistributionType = "Mpi",
 *                     ProcessCountPerInstance = 1,
 *                 },
 *                 EnvironmentId = "string",
 *                 EnvironmentVariables =
 *                 {
 *                     { "string", "string" },
 *                 },
 *                 Resources = new AzureNative.MachineLearningServices.Inputs.JobResourceConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     InstanceType = "string",
 *                     Properties =
 *                     {
 *                         { "string",
 *                         {
 *                             { "e6b6493e-7d5e-4db3-be1e-306ec641327e", null },
 *                         } },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "test-rg",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := machinelearningservices.NewJob(ctx, "job", &machinelearningservices.JobArgs{
 * Id: pulumi.String("string"),
 * JobBaseProperties: machinelearningservices.SweepJob{
 * ComputeId: "string",
 * Description: "string",
 * DisplayName: "string",
 * EarlyTermination: machinelearningservices.MedianStoppingPolicy{
 * DelayEvaluation: 1,
 * EvaluationInterval: 1,
 * PolicyType: "MedianStopping",
 * },
 * ExperimentName: "string",
 * JobType: "Sweep",
 * Limits: machinelearningservices.SweepJobLimits{
 * JobLimitsType: "Sweep",
 * MaxConcurrentTrials: 1,
 * MaxTotalTrials: 1,
 * TrialTimeout: "PT1S",
 * },
 * Objective: machinelearningservices.Objective{
 * Goal: "Minimize",
 * PrimaryMetric: "string",
 * },
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * SamplingAlgorithm: machinelearningservices.GridSamplingAlgorithm{
 * SamplingAlgorithmType: "Grid",
 * },
 * SearchSpace: map[string]interface{}{
 * "string": nil,
 * },
 * Services: interface{}{
 * String: machinelearningservices.JobService{
 * Endpoint: "string",
 * JobServiceType: "string",
 * Port: 1,
 * Properties: map[string]interface{}{
 * "string": "string",
 * },
 * },
 * },
 * Tags: map[string]interface{}{
 * "string": "string",
 * },
 * Trial: machinelearningservices.TrialComponent{
 * CodeId: "string",
 * Command: "string",
 * Distribution: machinelearningservices.Mpi{
 * DistributionType: "Mpi",
 * ProcessCountPerInstance: 1,
 * },
 * EnvironmentId: "string",
 * EnvironmentVariables: map[string]interface{}{
 * "string": "string",
 * },
 * Resources: machinelearningservices.JobResourceConfiguration{
 * InstanceCount: 1,
 * InstanceType: "string",
 * Properties: map[string]interface{}{
 * "string": map[string]interface{}{
 * "e6b6493e-7d5e-4db3-be1e-306ec641327e": nil,
 * },
 * },
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("test-rg"),
 * WorkspaceName: pulumi.String("my-aml-workspace"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.Job;
 * import com.pulumi.azurenative.machinelearningservices.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .id("string")
 *             .jobBaseProperties(Map.ofEntries(
 *                 Map.entry("computeId", "string"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("displayName", "string"),
 *                 Map.entry("earlyTermination", Map.ofEntries(
 *                     Map.entry("delayEvaluation", 1),
 *                     Map.entry("evaluationInterval", 1),
 *                     Map.entry("policyType", "MedianStopping")
 *                 )),
 *                 Map.entry("experimentName", "string"),
 *                 Map.entry("jobType", "Sweep"),
 *                 Map.entry("limits", Map.ofEntries(
 *                     Map.entry("jobLimitsType", "Sweep"),
 *                     Map.entry("maxConcurrentTrials", 1),
 *                     Map.entry("maxTotalTrials", 1),
 *                     Map.entry("trialTimeout", "PT1S")
 *                 )),
 *                 Map.entry("objective", Map.ofEntries(
 *                     Map.entry("goal", "Minimize"),
 *                     Map.entry("primaryMetric", "string")
 *                 )),
 *                 Map.entry("properties", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build()),
 *                 Map.entry("samplingAlgorithm", Map.of("samplingAlgorithmType", "Grid")),
 *                 Map.entry("searchSpace", AutoMLJobArgs.builder()
 *                     .string()
 *                     .build()),
 *                 Map.entry("services", Map.of("string", Map.ofEntries(
 *                     Map.entry("endpoint", "string"),
 *                     Map.entry("jobServiceType", "string"),
 *                     Map.entry("port", 1),
 *                     Map.entry("properties", AutoMLJobArgs.builder()
 *                         .string("string")
 *                         .build())
 *                 ))),
 *                 Map.entry("tags", AutoMLJobArgs.builder()
 *                     .string("string")
 *                     .build()),
 *                 Map.entry("trial", Map.ofEntries(
 *                     Map.entry("codeId", "string"),
 *                     Map.entry("command", "string"),
 *                     Map.entry("distribution", Map.ofEntries(
 *                         Map.entry("distributionType", "Mpi"),
 *                         Map.entry("processCountPerInstance", 1)
 *                     )),
 *                     Map.entry("environmentId", "string"),
 *                     Map.entry("environmentVariables", AutoMLJobArgs.builder()
 *                         .string("string")
 *                         .build()),
 *                     Map.entry("resources", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("instanceType", "string"),
 *                         Map.entry("properties", AutoMLJobArgs.builder()
 *                             .string(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                             .build())
 *                     ))
 *                 ))
 *             ))
 *             .resourceGroupName("test-rg")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:Job string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/jobs/{id}
 * ```
 * @property id The name and identifier for the Job. This is case-sensitive.
 * @property jobBaseProperties [Required] Additional attributes of the entity.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class JobArgs(
    public val id: Output<String>? = null,
    public val jobBaseProperties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.JobArgs =
        com.pulumi.azurenative.machinelearningservices.JobArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .jobBaseProperties(jobBaseProperties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var jobBaseProperties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The name and identifier for the Job. This is case-sensitive.
     */
    @JvmName("yekteicokcwalcwh")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("rerdtfcbkebamuej")
    public suspend fun jobBaseProperties(`value`: Output<Any>) {
        this.jobBaseProperties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tlcfflnnpwoibgwp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("ospdmppqyijnjeat")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The name and identifier for the Job. This is case-sensitive.
     */
    @JvmName("jofeeokfvfdwvavv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("kjbnxtkjmffdmywp")
    public suspend fun jobBaseProperties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobBaseProperties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gcttlibloyhegdwn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("upwtthdasteasnlm")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        id = id,
        jobBaseProperties = jobBaseProperties,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
