@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.DatasetResponse.Companion.toKotlin as datasetResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [MachineLearningDataset].
 */
@PulumiTagMarker
public class MachineLearningDatasetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MachineLearningDatasetArgs = MachineLearningDatasetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MachineLearningDatasetArgsBuilder.() -> Unit) {
        val builder = MachineLearningDatasetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MachineLearningDataset {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.MachineLearningDataset(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MachineLearningDataset(builtJavaResource)
    }
}

/**
 * Machine Learning dataset object wrapped into ARM resource envelope.
 * Azure REST API version: 2020-05-01-preview. Prior API version in Azure Native 1.x: 2020-05-01-preview.
 * ## Example Usage
 * ### Create Dataset
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineLearningDataset = new AzureNative.MachineLearningServices.MachineLearningDataset("machineLearningDataset", new()
 *     {
 *         DatasetName = "datasetName123",
 *         DatasetType = "file",
 *         Parameters = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestParametersArgs
 *         {
 *             Path = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestPathArgs
 *             {
 *                 DataPath = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestDataPathArgs
 *                 {
 *                     DatastoreName = "testblobfromarm",
 *                     RelativePath = "UI/03-26-2020_083359_UTC/latin1encoding.csv",
 *                 },
 *             },
 *         },
 *         Registration = new AzureNative.MachineLearningServices.Inputs.DatasetCreateRequestRegistrationArgs
 *         {
 *             Description = "test description",
 *             Name = "datasetName123",
 *         },
 *         ResourceGroupName = "acjain-mleastUS2",
 *         SkipValidation = false,
 *         WorkspaceName = "acjain-mleastUS2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewMachineLearningDataset(ctx, "machineLearningDataset", &machinelearningservices.MachineLearningDatasetArgs{
 * 			DatasetName: pulumi.String("datasetName123"),
 * 			DatasetType: pulumi.String("file"),
 * 			Parameters: &machinelearningservices.DatasetCreateRequestParametersArgs{
 * 				Path: &machinelearningservices.DatasetCreateRequestPathArgs{
 * 					DataPath: &machinelearningservices.DatasetCreateRequestDataPathArgs{
 * 						DatastoreName: pulumi.String("testblobfromarm"),
 * 						RelativePath:  pulumi.String("UI/03-26-2020_083359_UTC/latin1encoding.csv"),
 * 					},
 * 				},
 * 			},
 * 			Registration: &machinelearningservices.DatasetCreateRequestRegistrationArgs{
 * 				Description: pulumi.String("test description"),
 * 				Name:        pulumi.String("datasetName123"),
 * 			},
 * 			ResourceGroupName: pulumi.String("acjain-mleastUS2"),
 * 			SkipValidation:    pulumi.Bool(false),
 * 			WorkspaceName:     pulumi.String("acjain-mleastUS2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDataset;
 * import com.pulumi.azurenative.machinelearningservices.MachineLearningDatasetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineLearningDataset = new MachineLearningDataset("machineLearningDataset", MachineLearningDatasetArgs.builder()
 *             .datasetName("datasetName123")
 *             .datasetType("file")
 *             .parameters(Map.of("path", Map.of("dataPath", Map.ofEntries(
 *                 Map.entry("datastoreName", "testblobfromarm"),
 *                 Map.entry("relativePath", "UI/03-26-2020_083359_UTC/latin1encoding.csv")
 *             ))))
 *             .registration(Map.ofEntries(
 *                 Map.entry("description", "test description"),
 *                 Map.entry("name", "datasetName123")
 *             ))
 *             .resourceGroupName("acjain-mleastUS2")
 *             .skipValidation(false)
 *             .workspaceName("acjain-mleastUS2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:MachineLearningDataset datasetName123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/datasets/{datasetName}
 * ```
 */
public class MachineLearningDataset internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.MachineLearningDataset,
) : KotlinCustomResource(javaResource, MachineLearningDatasetMapper) {
    /**
     * The identity of the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the location of the resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Dataset properties
     */
    public val properties: Output<DatasetResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                datasetResponseToKotlin(args0)
            })
        })

    /**
     * The sku of the workspace.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains resource tags defined as key/value pairs.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MachineLearningDatasetMapper : ResourceMapper<MachineLearningDataset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.MachineLearningDataset::class == javaResource::class

    override fun map(javaResource: Resource): MachineLearningDataset =
        MachineLearningDataset(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.MachineLearningDataset,
        )
}

/**
 * @see [MachineLearningDataset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MachineLearningDataset].
 */
public suspend fun machineLearningDataset(
    name: String,
    block: suspend MachineLearningDatasetResourceBuilder.() -> Unit,
): MachineLearningDataset {
    val builder = MachineLearningDatasetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MachineLearningDataset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun machineLearningDataset(name: String): MachineLearningDataset {
    val builder = MachineLearningDatasetResourceBuilder()
    builder.name(name)
    return builder.build()
}
