@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelVersionResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.ModelVersionResponse.Companion.toKotlin as modelVersionResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ModelVersion].
 */
@PulumiTagMarker
public class ModelVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ModelVersionArgs = ModelVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ModelVersionArgsBuilder.() -> Unit) {
        val builder = ModelVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ModelVersion {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.ModelVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ModelVersion(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-03-01-preview, 2022-02-01-preview, 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Workspace Model Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var modelVersion = new AzureNative.MachineLearningServices.ModelVersion("modelVersion", new()
 *     {
 *         ModelVersionProperties = new AzureNative.MachineLearningServices.Inputs.ModelVersionArgs
 *         {
 *             Description = "string",
 *             Flavors =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.FlavorDataArgs
 *                 {
 *                     Data =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             IsAnonymous = false,
 *             ModelType = "CustomModel",
 *             ModelUri = "string",
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *         WorkspaceName = "my-aml-workspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewModelVersion(ctx, "modelVersion", &machinelearningservices.ModelVersionArgs{
 * 			ModelVersionProperties: machinelearningservices.ModelVersionResponse{
 * 				Description: pulumi.String("string"),
 * 				Flavors: machinelearningservices.FlavorDataMap{
 * 					"string": &machinelearningservices.FlavorDataArgs{
 * 						Data: pulumi.StringMap{
 * 							"string": pulumi.String("string"),
 * 						},
 * 					},
 * 				},
 * 				IsAnonymous: pulumi.Bool(false),
 * 				ModelType:   pulumi.String("CustomModel"),
 * 				ModelUri:    pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 			WorkspaceName:     pulumi.String("my-aml-workspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.ModelVersion;
 * import com.pulumi.azurenative.machinelearningservices.ModelVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var modelVersion = new ModelVersion("modelVersion", ModelVersionArgs.builder()
 *             .modelVersionProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("flavors", Map.of("string", Map.of("data", Map.of("string", "string")))),
 *                 Map.entry("isAnonymous", false),
 *                 Map.entry("modelType", "CustomModel"),
 *                 Map.entry("modelUri", "string"),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .name("string")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .workspaceName("my-aml-workspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:ModelVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/workspaces/{workspaceName}/models/{name}/versions/{version}
 * ```
 */
public class ModelVersion internal constructor(
    override val javaResource: com.pulumi.azurenative.machinelearningservices.ModelVersion,
) : KotlinCustomResource(javaResource, ModelVersionMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val modelVersionProperties: Output<ModelVersionResponse>
        get() = javaResource.modelVersionProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                modelVersionResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ModelVersionMapper : ResourceMapper<ModelVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.ModelVersion::class == javaResource::class

    override fun map(javaResource: Resource): ModelVersion = ModelVersion(
        javaResource as
            com.pulumi.azurenative.machinelearningservices.ModelVersion,
    )
}

/**
 * @see [ModelVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ModelVersion].
 */
public suspend fun modelVersion(
    name: String,
    block: suspend ModelVersionResourceBuilder.() -> Unit,
): ModelVersion {
    val builder = ModelVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ModelVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun modelVersion(name: String): ModelVersion {
    val builder = ModelVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
