@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryCodeContainerArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeContainerArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.CodeContainerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Registry Code Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryCodeContainer = new AzureNative.MachineLearningServices.RegistryCodeContainer("registryCodeContainer", new()
 *     {
 *         CodeContainerProperties = new AzureNative.MachineLearningServices.Inputs.CodeContainerArgs
 *         {
 *             Description = "string",
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         CodeName = "testContainer",
 *         RegistryName = "testregistry",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryCodeContainer(ctx, "registryCodeContainer", &machinelearningservices.RegistryCodeContainerArgs{
 * 			CodeContainerProperties: &machinelearningservices.CodeContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			CodeName:          pulumi.String("testContainer"),
 * 			RegistryName:      pulumi.String("testregistry"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryCodeContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryCodeContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryCodeContainer = new RegistryCodeContainer("registryCodeContainer", RegistryCodeContainerArgs.builder()
 *             .codeContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *             ))
 *             .codeName("testContainer")
 *             .registryName("testregistry")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryCodeContainer testContainer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/codes/{codeName}
 * ```
 * @property codeContainerProperties [Required] Additional attributes of the entity.
 * @property codeName Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class RegistryCodeContainerArgs(
    public val codeContainerProperties: Output<CodeContainerArgs>? = null,
    public val codeName: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryCodeContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryCodeContainerArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryCodeContainerArgs.builder()
            .codeContainerProperties(
                codeContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .codeName(codeName?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryCodeContainerArgs].
 */
@PulumiTagMarker
public class RegistryCodeContainerArgsBuilder internal constructor() {
    private var codeContainerProperties: Output<CodeContainerArgs>? = null

    private var codeName: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("xjgewddgoprgjabf")
    public suspend fun codeContainerProperties(`value`: Output<CodeContainerArgs>) {
        this.codeContainerProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("vdfhxejpiffggoeb")
    public suspend fun codeName(`value`: Output<String>) {
        this.codeName = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("ggcqybiuvtpetrdl")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ityuynhawnrosoys")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("pikxccoyekiqcxdu")
    public suspend fun codeContainerProperties(`value`: CodeContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("cmowgbchmwralyey")
    public suspend
    fun codeContainerProperties(argument: suspend CodeContainerArgsBuilder.() -> Unit) {
        val toBeMapped = CodeContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.codeContainerProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("iomeiynwnsqmfuic")
    public suspend fun codeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("xolfmwcswrcilssv")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("foshjfwxochqlwvy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RegistryCodeContainerArgs = RegistryCodeContainerArgs(
        codeContainerProperties = codeContainerProperties,
        codeName = codeName,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
