@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryDataContainerArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DataContainerArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.DataContainerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Registry Data Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryDataContainer = new AzureNative.MachineLearningServices.RegistryDataContainer("registryDataContainer", new()
 *     {
 *         DataContainerProperties = new AzureNative.MachineLearningServices.Inputs.DataContainerArgs
 *         {
 *             DataType = "uri_folder",
 *             Description = "string",
 *             IsArchived = false,
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         Name = "string",
 *         RegistryName = "registryName",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryDataContainer(ctx, "registryDataContainer", &machinelearningservices.RegistryDataContainerArgs{
 * 			DataContainerProperties: &machinelearningservices.DataContainerTypeArgs{
 * 				DataType:    pulumi.String("uri_folder"),
 * 				Description: pulumi.String("string"),
 * 				IsArchived:  pulumi.Bool(false),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			Name:              pulumi.String("string"),
 * 			RegistryName:      pulumi.String("registryName"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryDataContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryDataContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryDataContainer = new RegistryDataContainer("registryDataContainer", RegistryDataContainerArgs.builder()
 *             .dataContainerProperties(Map.ofEntries(
 *                 Map.entry("dataType", "uri_folder"),
 *                 Map.entry("description", "string"),
 *                 Map.entry("isArchived", false),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .name("string")
 *             .registryName("registryName")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryDataContainer string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/data/{name}
 * ```
 * @property dataContainerProperties [Required] Additional attributes of the entity.
 * @property name Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class RegistryDataContainerArgs(
    public val dataContainerProperties: Output<DataContainerArgs>? = null,
    public val name: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryDataContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryDataContainerArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryDataContainerArgs.builder()
            .dataContainerProperties(
                dataContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryDataContainerArgs].
 */
@PulumiTagMarker
public class RegistryDataContainerArgsBuilder internal constructor() {
    private var dataContainerProperties: Output<DataContainerArgs>? = null

    private var name: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("nxyklecjccevdsto")
    public suspend fun dataContainerProperties(`value`: Output<DataContainerArgs>) {
        this.dataContainerProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("leyqwhsexptgdvjv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("boogwlfsykiuspap")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cqcmwpvwlhungjty")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("bjumsmqgeyureoci")
    public suspend fun dataContainerProperties(`value`: DataContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("qqqkdhookmqqpmvy")
    public suspend
    fun dataContainerProperties(argument: suspend DataContainerArgsBuilder.() -> Unit) {
        val toBeMapped = DataContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataContainerProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("gwhrnheivkekypqr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("fivsovoinstwwngq")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gnmewfnrbmeodcll")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RegistryDataContainerArgs = RegistryDataContainerArgs(
        dataContainerProperties = dataContainerProperties,
        name = name,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
