@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentContainerResponse
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.EnvironmentContainerResponse.Companion.toKotlin as environmentContainerResponseToKotlin
import com.pulumi.azurenative.machinelearningservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [RegistryEnvironmentContainer].
 */
@PulumiTagMarker
public class RegistryEnvironmentContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegistryEnvironmentContainerArgs = RegistryEnvironmentContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegistryEnvironmentContainerArgsBuilder.() -> Unit) {
        val builder = RegistryEnvironmentContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): RegistryEnvironmentContainer {
        val builtJavaResource =
            com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainer(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RegistryEnvironmentContainer(builtJavaResource)
    }
}

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Registry Environment Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryEnvironmentContainer = new AzureNative.MachineLearningServices.RegistryEnvironmentContainer("registryEnvironmentContainer", new()
 *     {
 *         EnvironmentContainerProperties = new AzureNative.MachineLearningServices.Inputs.EnvironmentContainerArgs
 *         {
 *             Description = "string",
 *             Properties =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "additionalProp1", "string" },
 *                 { "additionalProp2", "string" },
 *                 { "additionalProp3", "string" },
 *             },
 *         },
 *         EnvironmentName = "testEnvironment",
 *         RegistryName = "testregistry",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryEnvironmentContainer(ctx, "registryEnvironmentContainer", &machinelearningservices.RegistryEnvironmentContainerArgs{
 * 			EnvironmentContainerProperties: &machinelearningservices.EnvironmentContainerTypeArgs{
 * 				Description: pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"additionalProp1": pulumi.String("string"),
 * 					"additionalProp2": pulumi.String("string"),
 * 					"additionalProp3": pulumi.String("string"),
 * 				},
 * 			},
 * 			EnvironmentName:   pulumi.String("testEnvironment"),
 * 			RegistryName:      pulumi.String("testregistry"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryEnvironmentContainer = new RegistryEnvironmentContainer("registryEnvironmentContainer", RegistryEnvironmentContainerArgs.builder()
 *             .environmentContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("properties", Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 )),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("additionalProp1", "string"),
 *                     Map.entry("additionalProp2", "string"),
 *                     Map.entry("additionalProp3", "string")
 *                 ))
 *             ))
 *             .environmentName("testEnvironment")
 *             .registryName("testregistry")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryEnvironmentContainer testEnvironment /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/environments/{environmentName}
 * ```
 */
public class RegistryEnvironmentContainer internal constructor(
    override val javaResource:
    com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainer,
) : KotlinCustomResource(javaResource, RegistryEnvironmentContainerMapper) {
    /**
     * [Required] Additional attributes of the entity.
     */
    public val environmentContainerProperties: Output<EnvironmentContainerResponse>
        get() = javaResource.environmentContainerProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                environmentContainerResponseToKotlin(args0)
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RegistryEnvironmentContainerMapper : ResourceMapper<RegistryEnvironmentContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainer::class == javaResource::class

    override fun map(javaResource: Resource): RegistryEnvironmentContainer =
        RegistryEnvironmentContainer(
            javaResource as
                com.pulumi.azurenative.machinelearningservices.RegistryEnvironmentContainer,
        )
}

/**
 * @see [RegistryEnvironmentContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegistryEnvironmentContainer].
 */
public suspend fun registryEnvironmentContainer(
    name: String,
    block: suspend RegistryEnvironmentContainerResourceBuilder.() -> Unit,
):
    RegistryEnvironmentContainer {
    val builder = RegistryEnvironmentContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegistryEnvironmentContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun registryEnvironmentContainer(name: String): RegistryEnvironmentContainer {
    val builder = RegistryEnvironmentContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
