@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryModelContainerArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelContainerArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelContainerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Registry Model Container.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryModelContainer = new AzureNative.MachineLearningServices.RegistryModelContainer("registryModelContainer", new()
 *     {
 *         ModelContainerProperties = new AzureNative.MachineLearningServices.Inputs.ModelContainerArgs
 *         {
 *             Description = "Model container description",
 *             Tags =
 *             {
 *                 { "tag1", "value1" },
 *                 { "tag2", "value2" },
 *             },
 *         },
 *         ModelName = "testContainer",
 *         RegistryName = "registry123",
 *         ResourceGroupName = "testrg123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryModelContainer(ctx, "registryModelContainer", &machinelearningservices.RegistryModelContainerArgs{
 * 			ModelContainerProperties: &machinelearningservices.ModelContainerTypeArgs{
 * 				Description: pulumi.String("Model container description"),
 * 				Tags: pulumi.StringMap{
 * 					"tag1": pulumi.String("value1"),
 * 					"tag2": pulumi.String("value2"),
 * 				},
 * 			},
 * 			ModelName:         pulumi.String("testContainer"),
 * 			RegistryName:      pulumi.String("registry123"),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryModelContainer;
 * import com.pulumi.azurenative.machinelearningservices.RegistryModelContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryModelContainer = new RegistryModelContainer("registryModelContainer", RegistryModelContainerArgs.builder()
 *             .modelContainerProperties(Map.ofEntries(
 *                 Map.entry("description", "Model container description"),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("tag1", "value1"),
 *                     Map.entry("tag2", "value2")
 *                 ))
 *             ))
 *             .modelName("testContainer")
 *             .registryName("registry123")
 *             .resourceGroupName("testrg123")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryModelContainer testContainer /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/models/{modelName}
 * ```
 * @property modelContainerProperties [Required] Additional attributes of the entity.
 * @property modelName Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class RegistryModelContainerArgs(
    public val modelContainerProperties: Output<ModelContainerArgs>? = null,
    public val modelName: Output<String>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryModelContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryModelContainerArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryModelContainerArgs.builder()
            .modelContainerProperties(
                modelContainerProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .modelName(modelName?.applyValue({ args0 -> args0 }))
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryModelContainerArgs].
 */
@PulumiTagMarker
public class RegistryModelContainerArgsBuilder internal constructor() {
    private var modelContainerProperties: Output<ModelContainerArgs>? = null

    private var modelName: Output<String>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("qglfalsyxloaskmk")
    public suspend fun modelContainerProperties(`value`: Output<ModelContainerArgs>) {
        this.modelContainerProperties = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("oengdufuqfrjdvru")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("hlhxbjaijpwrflpg")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ybnbjndryowunbtg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("djssjocsbnowqkqt")
    public suspend fun modelContainerProperties(`value`: ModelContainerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelContainerProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("arnpvksfvprdodac")
    public suspend
    fun modelContainerProperties(argument: suspend ModelContainerArgsBuilder.() -> Unit) {
        val toBeMapped = ModelContainerArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.modelContainerProperties = mapped
    }

    /**
     * @param value Container name.
     */
    @JvmName("eqelydvxravoamxw")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("mvfwbfdsyghkaolc")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("velkbijndqjgngwe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): RegistryModelContainerArgs = RegistryModelContainerArgs(
        modelContainerProperties = modelContainerProperties,
        modelName = modelName,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
    )
}
