@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin

import com.pulumi.azurenative.machinelearningservices.RegistryModelVersionArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelVersionArgs
import com.pulumi.azurenative.machinelearningservices.kotlin.inputs.ModelVersionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Resource Manager resource envelope.
 * Azure REST API version: 2023-04-01.
 * Other available API versions: 2023-04-01-preview, 2023-06-01-preview, 2023-08-01-preview, 2023-10-01.
 * ## Example Usage
 * ### CreateOrUpdate Registry Model Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var registryModelVersion = new AzureNative.MachineLearningServices.RegistryModelVersion("registryModelVersion", new()
 *     {
 *         ModelName = "string",
 *         ModelVersionProperties = new AzureNative.MachineLearningServices.Inputs.ModelVersionArgs
 *         {
 *             Description = "string",
 *             Flavors =
 *             {
 *                 { "string", new AzureNative.MachineLearningServices.Inputs.FlavorDataArgs
 *                 {
 *                     Data =
 *                     {
 *                         { "string", "string" },
 *                     },
 *                 } },
 *             },
 *             IsAnonymous = false,
 *             ModelType = "CustomModel",
 *             ModelUri = "string",
 *             Properties =
 *             {
 *                 { "string", "string" },
 *             },
 *             Tags =
 *             {
 *                 { "string", "string" },
 *             },
 *         },
 *         RegistryName = "my-aml-registry",
 *         ResourceGroupName = "test-rg",
 *         Version = "string",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/machinelearningservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := machinelearningservices.NewRegistryModelVersion(ctx, "registryModelVersion", &machinelearningservices.RegistryModelVersionArgs{
 * 			ModelName: pulumi.String("string"),
 * 			ModelVersionProperties: machinelearningservices.ModelVersionResponse{
 * 				Description: pulumi.String("string"),
 * 				Flavors: machinelearningservices.FlavorDataMap{
 * 					"string": &machinelearningservices.FlavorDataArgs{
 * 						Data: pulumi.StringMap{
 * 							"string": pulumi.String("string"),
 * 						},
 * 					},
 * 				},
 * 				IsAnonymous: pulumi.Bool(false),
 * 				ModelType:   pulumi.String("CustomModel"),
 * 				ModelUri:    pulumi.String("string"),
 * 				Properties: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 				Tags: pulumi.StringMap{
 * 					"string": pulumi.String("string"),
 * 				},
 * 			},
 * 			RegistryName:      pulumi.String("my-aml-registry"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Version:           pulumi.String("string"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.machinelearningservices.RegistryModelVersion;
 * import com.pulumi.azurenative.machinelearningservices.RegistryModelVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var registryModelVersion = new RegistryModelVersion("registryModelVersion", RegistryModelVersionArgs.builder()
 *             .modelName("string")
 *             .modelVersionProperties(Map.ofEntries(
 *                 Map.entry("description", "string"),
 *                 Map.entry("flavors", Map.of("string", Map.of("data", Map.of("string", "string")))),
 *                 Map.entry("isAnonymous", false),
 *                 Map.entry("modelType", "CustomModel"),
 *                 Map.entry("modelUri", "string"),
 *                 Map.entry("properties", Map.of("string", "string")),
 *                 Map.entry("tags", Map.of("string", "string"))
 *             ))
 *             .registryName("my-aml-registry")
 *             .resourceGroupName("test-rg")
 *             .version("string")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:machinelearningservices:RegistryModelVersion string /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearningServices/registries/{registryName}/models/{modelName}/versions/{version}
 * ```
 * @property modelName Container name.
 * @property modelVersionProperties [Required] Additional attributes of the entity.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property version Version identifier.
 */
public data class RegistryModelVersionArgs(
    public val modelName: Output<String>? = null,
    public val modelVersionProperties: Output<ModelVersionArgs>? = null,
    public val registryName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.RegistryModelVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.RegistryModelVersionArgs =
        com.pulumi.azurenative.machinelearningservices.RegistryModelVersionArgs.builder()
            .modelName(modelName?.applyValue({ args0 -> args0 }))
            .modelVersionProperties(
                modelVersionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RegistryModelVersionArgs].
 */
@PulumiTagMarker
public class RegistryModelVersionArgsBuilder internal constructor() {
    private var modelName: Output<String>? = null

    private var modelVersionProperties: Output<ModelVersionArgs>? = null

    private var registryName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Container name.
     */
    @JvmName("ythaobmscbnoytid")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("jovgoyxjfohhotou")
    public suspend fun modelVersionProperties(`value`: Output<ModelVersionArgs>) {
        this.modelVersionProperties = value
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("hphwdpqfaruekogu")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tjqgjiqwihqyhjgi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("wjbvkdxgnrlswwxg")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Container name.
     */
    @JvmName("kxvjauxjaqfpwnpt")
    public suspend fun modelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value [Required] Additional attributes of the entity.
     */
    @JvmName("ulpeiyxyqrcicrqk")
    public suspend fun modelVersionProperties(`value`: ModelVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelVersionProperties = mapped
    }

    /**
     * @param argument [Required] Additional attributes of the entity.
     */
    @JvmName("jeekmtyibogispeo")
    public suspend fun modelVersionProperties(argument: suspend ModelVersionArgsBuilder.() -> Unit) {
        val toBeMapped = ModelVersionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.modelVersionProperties = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("athhqllsfeitnhvd")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kruguoijomtiikyu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Version identifier.
     */
    @JvmName("kqmigjoircmfwkuf")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): RegistryModelVersionArgs = RegistryModelVersionArgs(
        modelName = modelName,
        modelVersionProperties = modelVersionProperties,
        registryName = registryName,
        resourceGroupName = resourceGroupName,
        version = version,
    )
}
