@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication. 'Key' doesn't expire but 'AMLToken' does.
 */
public enum class EndpointAuthMode(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.EndpointAuthMode,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.EndpointAuthMode> {
    AMLToken(com.pulumi.azurenative.machinelearningservices.enums.EndpointAuthMode.AMLToken),
    Key(com.pulumi.azurenative.machinelearningservices.enums.EndpointAuthMode.Key),
    AADToken(com.pulumi.azurenative.machinelearningservices.enums.EndpointAuthMode.AADToken),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.EndpointAuthMode =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.EndpointAuthMode):
            EndpointAuthMode = EndpointAuthMode.values().first { it.javaValue == javaType }
    }
}
