@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Flag for generating lags for the numeric features with 'auto' or null.
 */
public enum class FeatureLags(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.FeatureLags,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.FeatureLags> {
    /**
     * No feature lags generated.
     */
    None(com.pulumi.azurenative.machinelearningservices.enums.FeatureLags.None),

    /**
     * System auto-generates feature lags.
     */
    Auto(com.pulumi.azurenative.machinelearningservices.enums.FeatureLags.Auto),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.FeatureLags =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.FeatureLags):
            FeatureLags = FeatureLags.values().first { it.javaValue == javaType }
    }
}
