@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * [Required] The frequency to trigger schedule.
 */
public enum class RecurrenceFrequency(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency> {
    /**
     * Minute frequency
     */
    Minute(com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency.Minute),

    /**
     * Hour frequency
     */
    Hour(com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency.Hour),

    /**
     * Day frequency
     */
    Day(com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency.Day),

    /**
     * Week frequency
     */
    Week(com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency.Week),

    /**
     * Month frequency
     */
    Month(com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency.Month),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.RecurrenceFrequency):
            RecurrenceFrequency = RecurrenceFrequency.values().first { it.javaValue == javaType }
    }
}
