@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the public ssh port is open and accessible according to the VNet/subnet policy if applicable.
 */
public enum class SshPublicAccess(
    public val javaValue: com.pulumi.azurenative.machinelearningservices.enums.SshPublicAccess,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.enums.SshPublicAccess> {
    Enabled(com.pulumi.azurenative.machinelearningservices.enums.SshPublicAccess.Enabled),
    Disabled(com.pulumi.azurenative.machinelearningservices.enums.SshPublicAccess.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.machinelearningservices.enums.SshPublicAccess =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.machinelearningservices.enums.SshPublicAccess):
            SshPublicAccess = SshPublicAccess.values().first { it.javaValue == javaType }
    }
}
