@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AKSSchemaPropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ClusterPurpose
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.LoadBalancerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * AKS properties
 * @property agentCount Number of agents
 * @property agentVmSize Agent virtual machine size
 * @property aksNetworkingConfiguration AKS networking configuration for vnet
 * @property clusterFqdn Cluster full qualified domain name
 * @property clusterPurpose Intended usage of the cluster
 * @property loadBalancerSubnet Load Balancer Subnet
 * @property loadBalancerType Load Balancer Type
 * @property sslConfiguration SSL configuration
 */
public data class AKSSchemaPropertiesArgs(
    public val agentCount: Output<Int>? = null,
    public val agentVmSize: Output<String>? = null,
    public val aksNetworkingConfiguration: Output<AksNetworkingConfigurationArgs>? = null,
    public val clusterFqdn: Output<String>? = null,
    public val clusterPurpose: Output<Either<String, ClusterPurpose>>? = null,
    public val loadBalancerSubnet: Output<String>? = null,
    public val loadBalancerType: Output<Either<String, LoadBalancerType>>? = null,
    public val sslConfiguration: Output<SslConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AKSSchemaPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AKSSchemaPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AKSSchemaPropertiesArgs.builder()
            .agentCount(agentCount?.applyValue({ args0 -> args0 }))
            .agentVmSize(agentVmSize?.applyValue({ args0 -> args0 }))
            .aksNetworkingConfiguration(
                aksNetworkingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .clusterFqdn(clusterFqdn?.applyValue({ args0 -> args0 }))
            .clusterPurpose(
                clusterPurpose?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .loadBalancerSubnet(loadBalancerSubnet?.applyValue({ args0 -> args0 }))
            .loadBalancerType(
                loadBalancerType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .sslConfiguration(
                sslConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AKSSchemaPropertiesArgs].
 */
@PulumiTagMarker
public class AKSSchemaPropertiesArgsBuilder internal constructor() {
    private var agentCount: Output<Int>? = null

    private var agentVmSize: Output<String>? = null

    private var aksNetworkingConfiguration: Output<AksNetworkingConfigurationArgs>? = null

    private var clusterFqdn: Output<String>? = null

    private var clusterPurpose: Output<Either<String, ClusterPurpose>>? = null

    private var loadBalancerSubnet: Output<String>? = null

    private var loadBalancerType: Output<Either<String, LoadBalancerType>>? = null

    private var sslConfiguration: Output<SslConfigurationArgs>? = null

    /**
     * @param value Number of agents
     */
    @JvmName("norrfkdikykmxbps")
    public suspend fun agentCount(`value`: Output<Int>) {
        this.agentCount = value
    }

    /**
     * @param value Agent virtual machine size
     */
    @JvmName("fwlmiaqkerrwgjan")
    public suspend fun agentVmSize(`value`: Output<String>) {
        this.agentVmSize = value
    }

    /**
     * @param value AKS networking configuration for vnet
     */
    @JvmName("musfayhungcyyhuo")
    public suspend fun aksNetworkingConfiguration(`value`: Output<AksNetworkingConfigurationArgs>) {
        this.aksNetworkingConfiguration = value
    }

    /**
     * @param value Cluster full qualified domain name
     */
    @JvmName("kmxbcwatqpdksqwe")
    public suspend fun clusterFqdn(`value`: Output<String>) {
        this.clusterFqdn = value
    }

    /**
     * @param value Intended usage of the cluster
     */
    @JvmName("hevahycdiuddsycf")
    public suspend fun clusterPurpose(`value`: Output<Either<String, ClusterPurpose>>) {
        this.clusterPurpose = value
    }

    /**
     * @param value Load Balancer Subnet
     */
    @JvmName("gvgkrvayshikxlml")
    public suspend fun loadBalancerSubnet(`value`: Output<String>) {
        this.loadBalancerSubnet = value
    }

    /**
     * @param value Load Balancer Type
     */
    @JvmName("bjvpooutcohtkwlc")
    public suspend fun loadBalancerType(`value`: Output<Either<String, LoadBalancerType>>) {
        this.loadBalancerType = value
    }

    /**
     * @param value SSL configuration
     */
    @JvmName("aftjhlfhsxduxeyj")
    public suspend fun sslConfiguration(`value`: Output<SslConfigurationArgs>) {
        this.sslConfiguration = value
    }

    /**
     * @param value Number of agents
     */
    @JvmName("jeipvawmsrtmxvty")
    public suspend fun agentCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentCount = mapped
    }

    /**
     * @param value Agent virtual machine size
     */
    @JvmName("wermfucfjwslkmkl")
    public suspend fun agentVmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentVmSize = mapped
    }

    /**
     * @param value AKS networking configuration for vnet
     */
    @JvmName("sgeqckyvyjhkdofc")
    public suspend fun aksNetworkingConfiguration(`value`: AksNetworkingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aksNetworkingConfiguration = mapped
    }

    /**
     * @param argument AKS networking configuration for vnet
     */
    @JvmName("rbgjyfabegjfeeko")
    public suspend
    fun aksNetworkingConfiguration(argument: suspend AksNetworkingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AksNetworkingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aksNetworkingConfiguration = mapped
    }

    /**
     * @param value Cluster full qualified domain name
     */
    @JvmName("qkcnfsluwodfogxf")
    public suspend fun clusterFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterFqdn = mapped
    }

    /**
     * @param value Intended usage of the cluster
     */
    @JvmName("rfwdlifncasvoxab")
    public suspend fun clusterPurpose(`value`: Either<String, ClusterPurpose>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterPurpose = mapped
    }

    /**
     * @param value Intended usage of the cluster
     */
    @JvmName("khxwmnkyfgpvnlvg")
    public fun clusterPurpose(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ClusterPurpose>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterPurpose = mapped
    }

    /**
     * @param value Intended usage of the cluster
     */
    @JvmName("nxwaenigbirljsbc")
    public fun clusterPurpose(`value`: ClusterPurpose) {
        val toBeMapped = Either.ofRight<String, ClusterPurpose>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterPurpose = mapped
    }

    /**
     * @param value Load Balancer Subnet
     */
    @JvmName("usnstbpnvoamqfcc")
    public suspend fun loadBalancerSubnet(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerSubnet = mapped
    }

    /**
     * @param value Load Balancer Type
     */
    @JvmName("ksiilxsiurghomws")
    public suspend fun loadBalancerType(`value`: Either<String, LoadBalancerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value Load Balancer Type
     */
    @JvmName("dtwcbifwvilyaypi")
    public fun loadBalancerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoadBalancerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value Load Balancer Type
     */
    @JvmName("nxpkpmkqkrwsokcr")
    public fun loadBalancerType(`value`: LoadBalancerType) {
        val toBeMapped = Either.ofRight<String, LoadBalancerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerType = mapped
    }

    /**
     * @param value SSL configuration
     */
    @JvmName("soudtiuaiiwmdoyq")
    public suspend fun sslConfiguration(`value`: SslConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslConfiguration = mapped
    }

    /**
     * @param argument SSL configuration
     */
    @JvmName("nnwuvvlpkolrelkb")
    public suspend fun sslConfiguration(argument: suspend SslConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SslConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslConfiguration = mapped
    }

    internal fun build(): AKSSchemaPropertiesArgs = AKSSchemaPropertiesArgs(
        agentCount = agentCount,
        agentVmSize = agentVmSize,
        aksNetworkingConfiguration = aksNetworkingConfiguration,
        clusterFqdn = clusterFqdn,
        clusterPurpose = clusterPurpose,
        loadBalancerSubnet = loadBalancerSubnet,
        loadBalancerType = loadBalancerType,
        sslConfiguration = sslConfiguration,
    )
}
