@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AcrDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Details of ACR account to be used for the Registry
 * @property systemCreatedAcrAccount Details of system created ACR account to be used for the Registry
 * @property userCreatedAcrAccount Details of user created ACR account to be used for the Registry
 */
public data class AcrDetailsArgs(
    public val systemCreatedAcrAccount: Output<SystemCreatedAcrAccountArgs>? = null,
    public val userCreatedAcrAccount: Output<UserCreatedAcrAccountArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AcrDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AcrDetailsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AcrDetailsArgs.builder()
            .systemCreatedAcrAccount(
                systemCreatedAcrAccount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userCreatedAcrAccount(
                userCreatedAcrAccount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AcrDetailsArgs].
 */
@PulumiTagMarker
public class AcrDetailsArgsBuilder internal constructor() {
    private var systemCreatedAcrAccount: Output<SystemCreatedAcrAccountArgs>? = null

    private var userCreatedAcrAccount: Output<UserCreatedAcrAccountArgs>? = null

    /**
     * @param value Details of system created ACR account to be used for the Registry
     */
    @JvmName("joawfutkknjlxvsv")
    public suspend fun systemCreatedAcrAccount(`value`: Output<SystemCreatedAcrAccountArgs>) {
        this.systemCreatedAcrAccount = value
    }

    /**
     * @param value Details of user created ACR account to be used for the Registry
     */
    @JvmName("pdqnhcqbrhqomuny")
    public suspend fun userCreatedAcrAccount(`value`: Output<UserCreatedAcrAccountArgs>) {
        this.userCreatedAcrAccount = value
    }

    /**
     * @param value Details of system created ACR account to be used for the Registry
     */
    @JvmName("kqjluelwlcqhklem")
    public suspend fun systemCreatedAcrAccount(`value`: SystemCreatedAcrAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemCreatedAcrAccount = mapped
    }

    /**
     * @param argument Details of system created ACR account to be used for the Registry
     */
    @JvmName("ypkoxgibevqeyhdd")
    public suspend
    fun systemCreatedAcrAccount(argument: suspend SystemCreatedAcrAccountArgsBuilder.() -> Unit) {
        val toBeMapped = SystemCreatedAcrAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemCreatedAcrAccount = mapped
    }

    /**
     * @param value Details of user created ACR account to be used for the Registry
     */
    @JvmName("krajiilgwvnivotl")
    public suspend fun userCreatedAcrAccount(`value`: UserCreatedAcrAccountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userCreatedAcrAccount = mapped
    }

    /**
     * @param argument Details of user created ACR account to be used for the Registry
     */
    @JvmName("vpbanbbifktxdfbt")
    public suspend
    fun userCreatedAcrAccount(argument: suspend UserCreatedAcrAccountArgsBuilder.() -> Unit) {
        val toBeMapped = UserCreatedAcrAccountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userCreatedAcrAccount = mapped
    }

    internal fun build(): AcrDetailsArgs = AcrDetailsArgs(
        systemCreatedAcrAccount = systemCreatedAcrAccount,
        userCreatedAcrAccount = userCreatedAcrAccount,
    )
}
