@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AutoMLJobArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * AutoMLJob class.
 * Use this class for executing AutoML tasks like Classification/Regression etc.
 * See TaskType enum for all the tasks supported.
 * @property componentId ARM resource ID of the component resource.
 * @property computeId ARM resource ID of the compute resource.
 * @property description The asset description text.
 * @property displayName Display name of job.
 * @property environmentId The ARM resource ID of the Environment specification for the job.
 * This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
 * @property environmentVariables Environment variables included in the job.
 * @property experimentName The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
 * @property identity Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
 * Defaults to AmlToken if null.
 * @property isArchived Is the asset archived?
 * @property jobType Enum to determine the type of job.
 * Expected value is 'AutoML'.
 * @property outputs Mapping of output data bindings used in the job.
 * @property properties The asset property dictionary.
 * @property resources Compute Resource configuration for the job.
 * @property services List of JobEndpoints.
 * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 * @property taskDetails [Required] This represents scenario which can be one of Tables/NLP/Image
 */
public data class AutoMLJobArgs(
    public val componentId: Output<String>? = null,
    public val computeId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val experimentName: Output<String>? = null,
    public val identity: Output<Any>? = null,
    public val isArchived: Output<Boolean>? = null,
    public val jobType: Output<String>,
    public val outputs: Output<Map<String, Any>>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val resources: Output<JobResourceConfigurationArgs>? = null,
    public val services: Output<Map<String, JobServiceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taskDetails: Output<Any>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AutoMLJobArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.AutoMLJobArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AutoMLJobArgs.builder()
            .componentId(componentId?.applyValue({ args0 -> args0 }))
            .computeId(computeId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .experimentName(experimentName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0 }))
            .isArchived(isArchived?.applyValue({ args0 -> args0 }))
            .jobType(jobType.applyValue({ args0 -> args0 }))
            .outputs(outputs?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .services(
                services?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taskDetails(taskDetails.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoMLJobArgs].
 */
@PulumiTagMarker
public class AutoMLJobArgsBuilder internal constructor() {
    private var componentId: Output<String>? = null

    private var computeId: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var experimentName: Output<String>? = null

    private var identity: Output<Any>? = null

    private var isArchived: Output<Boolean>? = null

    private var jobType: Output<String>? = null

    private var outputs: Output<Map<String, Any>>? = null

    private var properties: Output<Map<String, String>>? = null

    private var resources: Output<JobResourceConfigurationArgs>? = null

    private var services: Output<Map<String, JobServiceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taskDetails: Output<Any>? = null

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("phrnoxwhkyvbdiny")
    public suspend fun componentId(`value`: Output<String>) {
        this.componentId = value
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("rbcdywrcifewtuny")
    public suspend fun computeId(`value`: Output<String>) {
        this.computeId = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("vutdjcaxmqbffiuw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("sybirxtfaedkorru")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The ARM resource ID of the Environment specification for the job.
     * This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
     */
    @JvmName("igantrflhulbywpo")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Environment variables included in the job.
     */
    @JvmName("dvsvcwkcpsjdemax")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("rvjqgekqngtagaer")
    public suspend fun experimentName(`value`: Output<String>) {
        this.experimentName = value
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("uumxhditnsjpsnsq")
    public suspend fun identity(`value`: Output<Any>) {
        this.identity = value
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("hvhtvbsssscahdqi")
    public suspend fun isArchived(`value`: Output<Boolean>) {
        this.isArchived = value
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'AutoML'.
     */
    @JvmName("kmwnlvpurdtwtrjb")
    public suspend fun jobType(`value`: Output<String>) {
        this.jobType = value
    }

    /**
     * @param value Mapping of output data bindings used in the job.
     */
    @JvmName("vtlfuigdwldyogyc")
    public suspend fun outputs(`value`: Output<Map<String, Any>>) {
        this.outputs = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("ibuegwremtwknalk")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Compute Resource configuration for the job.
     */
    @JvmName("ayyepqtjsftnrmaf")
    public suspend fun resources(`value`: Output<JobResourceConfigurationArgs>) {
        this.resources = value
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("dscgivbigrotrgvj")
    public suspend fun services(`value`: Output<Map<String, JobServiceArgs>>) {
        this.services = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ukkdqvhifdbdnpda")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [Required] This represents scenario which can be one of Tables/NLP/Image
     */
    @JvmName("efsmhxosmlolwfvt")
    public suspend fun taskDetails(`value`: Output<Any>) {
        this.taskDetails = value
    }

    /**
     * @param value ARM resource ID of the component resource.
     */
    @JvmName("qohpxhtguevhyyqf")
    public suspend fun componentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentId = mapped
    }

    /**
     * @param value ARM resource ID of the compute resource.
     */
    @JvmName("qpsvjrttdivskmtl")
    public suspend fun computeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeId = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("ejyvybahjepivijk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of job.
     */
    @JvmName("kqxyxaucolwqodgr")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The ARM resource ID of the Environment specification for the job.
     * This is optional value to provide, if not provided, AutoML will default this to Production AutoML curated environment version when running the job.
     */
    @JvmName("fdtfbyhxwrqxwxee")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Environment variables included in the job.
     */
    @JvmName("scyusklsijkassyb")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables included in the job.
     */
    @JvmName("bxmvsdtscwgcqppr")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
     */
    @JvmName("itwrsxpkfsvvaasf")
    public suspend fun experimentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.experimentName = mapped
    }

    /**
     * @param value Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null.
     * Defaults to AmlToken if null.
     */
    @JvmName("fkwsxjpyplbexwue")
    public suspend fun identity(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param value Is the asset archived?
     */
    @JvmName("vngpdxyfhnxqvbuk")
    public suspend fun isArchived(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchived = mapped
    }

    /**
     * @param value Enum to determine the type of job.
     * Expected value is 'AutoML'.
     */
    @JvmName("xcdexgnrlhujysbf")
    public suspend fun jobType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value Mapping of output data bindings used in the job.
     */
    @JvmName("luvyijjcdfktwhlj")
    public suspend fun outputs(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param values Mapping of output data bindings used in the job.
     */
    @JvmName("jusuynrpnpxxlopc")
    public fun outputs(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputs = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("dvxxgjtxwfxaqncg")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("ndtmaovrbduxpfxm")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Compute Resource configuration for the job.
     */
    @JvmName("ddjxoijuyjgwgucx")
    public suspend fun resources(`value`: JobResourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Compute Resource configuration for the job.
     */
    @JvmName("tauxqtvpugqfolxh")
    public suspend fun resources(argument: suspend JobResourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = JobResourceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("fyimxogglknjvdxd")
    public suspend fun services(`value`: Map<String, JobServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param argument List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("kyhllxlvkdwovwqk")
    public suspend fun services(
        vararg
        argument: Pair<String, suspend JobServiceArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                JobServiceArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    /**
     * @param values List of JobEndpoints.
     * For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
     */
    @JvmName("utuefthuhariuygj")
    public fun services(vararg values: Pair<String, JobServiceArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("xxraoaeuyukifjhc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("tfbnyaemnjrsyhvj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value [Required] This represents scenario which can be one of Tables/NLP/Image
     */
    @JvmName("gtpdvcaccnapxkjy")
    public suspend fun taskDetails(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskDetails = mapped
    }

    internal fun build(): AutoMLJobArgs = AutoMLJobArgs(
        componentId = componentId,
        computeId = computeId,
        description = description,
        displayName = displayName,
        environmentId = environmentId,
        environmentVariables = environmentVariables,
        experimentName = experimentName,
        identity = identity,
        isArchived = isArchived,
        jobType = jobType ?: throw PulumiNullFieldException("jobType"),
        outputs = outputs,
        properties = properties,
        resources = resources,
        services = services,
        tags = tags,
        taskDetails = taskDetails ?: throw PulumiNullFieldException("taskDetails"),
    )
}
