@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AzureBlobDatastoreArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ServiceDataAccessAuthIdentity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Blob datastore configuration.
 * @property accountName Storage account name.
 * @property containerName Storage account container name.
 * @property credentials [Required] Account credentials.
 * @property datastoreType Enum to determine the datastore contents type.
 * Expected value is 'AzureBlob'.
 * @property description The asset description text.
 * @property endpoint Azure cloud endpoint for the storage account.
 * @property properties The asset property dictionary.
 * @property protocol Protocol used to communicate with the storage account.
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class AzureBlobDatastoreArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val credentials: Output<Any>,
    public val datastoreType: Output<String>,
    public val description: Output<String>? = null,
    public val endpoint: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val protocol: Output<String>? = null,
    public val serviceDataAccessAuthIdentity: Output<Either<String, ServiceDataAccessAuthIdentity>>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AzureBlobDatastoreArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AzureBlobDatastoreArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AzureBlobDatastoreArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .credentials(credentials.applyValue({ args0 -> args0 }))
            .datastoreType(datastoreType.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .serviceDataAccessAuthIdentity(
                serviceDataAccessAuthIdentity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureBlobDatastoreArgs].
 */
@PulumiTagMarker
public class AzureBlobDatastoreArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var credentials: Output<Any>? = null

    private var datastoreType: Output<String>? = null

    private var description: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var protocol: Output<String>? = null

    private var serviceDataAccessAuthIdentity: Output<Either<String, ServiceDataAccessAuthIdentity>>? =
        null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Storage account name.
     */
    @JvmName("gtcvalivewrsdmab")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Storage account container name.
     */
    @JvmName("fikqnlcprtaqnkio")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value [Required] Account credentials.
     */
    @JvmName("beulkyiyohfriirf")
    public suspend fun credentials(`value`: Output<Any>) {
        this.credentials = value
    }

    /**
     * @param value Enum to determine the datastore contents type.
     * Expected value is 'AzureBlob'.
     */
    @JvmName("fvsbvpwopvlvdxkr")
    public suspend fun datastoreType(`value`: Output<String>) {
        this.datastoreType = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("nsqiiqwutfturtcm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Azure cloud endpoint for the storage account.
     */
    @JvmName("fjhsndnqetyqnfhl")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("jxmxgjttyjekwenk")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Protocol used to communicate with the storage account.
     */
    @JvmName("pwhdcmtfuiyclbjo")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("ipghklmruucshkme")
    public suspend
    fun serviceDataAccessAuthIdentity(`value`: Output<Either<String, ServiceDataAccessAuthIdentity>>) {
        this.serviceDataAccessAuthIdentity = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("ofpybanvrtrkpneq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Storage account name.
     */
    @JvmName("kbffwuuyppbrdcit")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Storage account container name.
     */
    @JvmName("gwgerjajwdcwqkyn")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value [Required] Account credentials.
     */
    @JvmName("lvytigmtqfgpjsoy")
    public suspend fun credentials(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value Enum to determine the datastore contents type.
     * Expected value is 'AzureBlob'.
     */
    @JvmName("hsxyohoyibfvcmwh")
    public suspend fun datastoreType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datastoreType = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("ijbwwkfebxbmcsqv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Azure cloud endpoint for the storage account.
     */
    @JvmName("fgojansnhafqcdrc")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("wgawwrmoalghcyfj")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("aluixphfddnrkkoo")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Protocol used to communicate with the storage account.
     */
    @JvmName("yjthyqfaddsjkwmm")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("ajybnassdoupgxyv")
    public suspend
    fun serviceDataAccessAuthIdentity(`value`: Either<String, ServiceDataAccessAuthIdentity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("wypjntqhmvcbadsv")
    public fun serviceDataAccessAuthIdentity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceDataAccessAuthIdentity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("hqdofcftohvrtyeh")
    public fun serviceDataAccessAuthIdentity(`value`: ServiceDataAccessAuthIdentity) {
        val toBeMapped = Either.ofRight<String, ServiceDataAccessAuthIdentity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("jgicmwjjeiyorxqf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("myoyqiwdyjyqxxaa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureBlobDatastoreArgs = AzureBlobDatastoreArgs(
        accountName = accountName,
        containerName = containerName,
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
        datastoreType = datastoreType ?: throw PulumiNullFieldException("datastoreType"),
        description = description,
        endpoint = endpoint,
        properties = properties,
        protocol = protocol,
        serviceDataAccessAuthIdentity = serviceDataAccessAuthIdentity,
        tags = tags,
    )
}
