@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.AzureDataLakeGen1DatastoreArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ServiceDataAccessAuthIdentity
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Data Lake Gen1 datastore configuration.
 * @property credentials [Required] Account credentials.
 * @property datastoreType Enum to determine the datastore contents type.
 * Expected value is 'AzureDataLakeGen1'.
 * @property description The asset description text.
 * @property properties The asset property dictionary.
 * @property serviceDataAccessAuthIdentity Indicates which identity to use to authenticate service data access to customer's storage.
 * @property storeName [Required] Azure Data Lake store name.
 * @property tags Tag dictionary. Tags can be added, removed, and updated.
 */
public data class AzureDataLakeGen1DatastoreArgs(
    public val credentials: Output<Any>,
    public val datastoreType: Output<String>,
    public val description: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val serviceDataAccessAuthIdentity: Output<Either<String, ServiceDataAccessAuthIdentity>>? =
        null,
    public val storeName: Output<String>,
    public val tags: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.AzureDataLakeGen1DatastoreArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.AzureDataLakeGen1DatastoreArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.AzureDataLakeGen1DatastoreArgs.builder()
            .credentials(credentials.applyValue({ args0 -> args0 }))
            .datastoreType(datastoreType.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .serviceDataAccessAuthIdentity(
                serviceDataAccessAuthIdentity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .storeName(storeName.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AzureDataLakeGen1DatastoreArgs].
 */
@PulumiTagMarker
public class AzureDataLakeGen1DatastoreArgsBuilder internal constructor() {
    private var credentials: Output<Any>? = null

    private var datastoreType: Output<String>? = null

    private var description: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var serviceDataAccessAuthIdentity: Output<Either<String, ServiceDataAccessAuthIdentity>>? =
        null

    private var storeName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value [Required] Account credentials.
     */
    @JvmName("syaivmfaqbkmusjj")
    public suspend fun credentials(`value`: Output<Any>) {
        this.credentials = value
    }

    /**
     * @param value Enum to determine the datastore contents type.
     * Expected value is 'AzureDataLakeGen1'.
     */
    @JvmName("lkheoycleqgeowkq")
    public suspend fun datastoreType(`value`: Output<String>) {
        this.datastoreType = value
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("uaxxnclnllwkgxcr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("pimprucudwllkrrr")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("rdtfbladtnhyevxl")
    public suspend
    fun serviceDataAccessAuthIdentity(`value`: Output<Either<String, ServiceDataAccessAuthIdentity>>) {
        this.serviceDataAccessAuthIdentity = value
    }

    /**
     * @param value [Required] Azure Data Lake store name.
     */
    @JvmName("utxlgvygdajeimns")
    public suspend fun storeName(`value`: Output<String>) {
        this.storeName = value
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("qtjxqlrhfknewefr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value [Required] Account credentials.
     */
    @JvmName("eoqtsfuqjrrxasaa")
    public suspend fun credentials(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param value Enum to determine the datastore contents type.
     * Expected value is 'AzureDataLakeGen1'.
     */
    @JvmName("piyybeosfjhjxmry")
    public suspend fun datastoreType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.datastoreType = mapped
    }

    /**
     * @param value The asset description text.
     */
    @JvmName("qrauhdbyvnbuioie")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The asset property dictionary.
     */
    @JvmName("qiaiiugerlcmeblk")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values The asset property dictionary.
     */
    @JvmName("xpylivdtwdopgswy")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("cgoukbbsuybuqqew")
    public suspend
    fun serviceDataAccessAuthIdentity(`value`: Either<String, ServiceDataAccessAuthIdentity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("vplnkqlusmodephu")
    public fun serviceDataAccessAuthIdentity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceDataAccessAuthIdentity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value Indicates which identity to use to authenticate service data access to customer's storage.
     */
    @JvmName("xvpnqfmiitqsbbvn")
    public fun serviceDataAccessAuthIdentity(`value`: ServiceDataAccessAuthIdentity) {
        val toBeMapped = Either.ofRight<String, ServiceDataAccessAuthIdentity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceDataAccessAuthIdentity = mapped
    }

    /**
     * @param value [Required] Azure Data Lake store name.
     */
    @JvmName("feakcjmkbhddxqem")
    public suspend fun storeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storeName = mapped
    }

    /**
     * @param value Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("byfeqvpoebmylnck")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tag dictionary. Tags can be added, removed, and updated.
     */
    @JvmName("afsipxbbtaibyhgr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AzureDataLakeGen1DatastoreArgs = AzureDataLakeGen1DatastoreArgs(
        credentials = credentials ?: throw PulumiNullFieldException("credentials"),
        datastoreType = datastoreType ?: throw PulumiNullFieldException("datastoreType"),
        description = description,
        properties = properties,
        serviceDataAccessAuthIdentity = serviceDataAccessAuthIdentity,
        storeName = storeName ?: throw PulumiNullFieldException("storeName"),
        tags = tags,
    )
}
