@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.BatchDeploymentArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.BatchLoggingLevel
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.BatchOutputAction
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Batch inference settings per deployment.
 * @property codeConfiguration Code configuration for the endpoint deployment.
 * @property compute Compute target for batch inference operation.
 * @property description Description of the endpoint deployment.
 * @property environmentId ARM resource ID or AssetId of the environment specification for the endpoint deployment.
 * @property environmentVariables Environment variables configuration for the deployment.
 * @property errorThreshold Error threshold, if the error count for the entire input goes above this value,
 * the batch inference will be aborted. Range is [-1, int&#46;MaxValue].
 * For FileDataset, this value is the count of file failures.
 * For TabularDataset, this value is the count of record failures.
 * If set to -1 (the lower bound), all failures during batch inference will be ignored.
 * @property loggingLevel Logging level for batch inference operation.
 * @property maxConcurrencyPerInstance Indicates maximum number of parallelism per instance.
 * @property miniBatchSize Size of the mini-batch passed to each batch invocation.
 * For FileDataset, this is the number of files per mini-batch.
 * For TabularDataset, this is the size of the records in bytes, per mini-batch.
 * @property model Reference to the model asset for the endpoint deployment.
 * @property outputAction Indicates how the output will be organized.
 * @property outputFileName Customized output file name for append_row output action.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property resources Indicates compute configuration for the job.
 * If not provided, will default to the defaults defined in ResourceConfiguration.
 * @property retrySettings Retry Settings for the batch inference operation.
 * If not provided, will default to the defaults defined in BatchRetrySettings.
 */
public data class BatchDeploymentArgs(
    public val codeConfiguration: Output<CodeConfigurationArgs>? = null,
    public val compute: Output<String>? = null,
    public val description: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val environmentVariables: Output<Map<String, String>>? = null,
    public val errorThreshold: Output<Int>? = null,
    public val loggingLevel: Output<Either<String, BatchLoggingLevel>>? = null,
    public val maxConcurrencyPerInstance: Output<Int>? = null,
    public val miniBatchSize: Output<Double>? = null,
    public val model: Output<Any>? = null,
    public val outputAction: Output<Either<String, BatchOutputAction>>? = null,
    public val outputFileName: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val resources: Output<DeploymentResourceConfigurationArgs>? = null,
    public val retrySettings: Output<BatchRetrySettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.BatchDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.BatchDeploymentArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.BatchDeploymentArgs.builder()
            .codeConfiguration(codeConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .compute(compute?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .errorThreshold(errorThreshold?.applyValue({ args0 -> args0 }))
            .loggingLevel(
                loggingLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .maxConcurrencyPerInstance(maxConcurrencyPerInstance?.applyValue({ args0 -> args0 }))
            .miniBatchSize(miniBatchSize?.applyValue({ args0 -> args0 }))
            .model(model?.applyValue({ args0 -> args0 }))
            .outputAction(
                outputAction?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .outputFileName(outputFileName?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retrySettings(retrySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BatchDeploymentArgs].
 */
@PulumiTagMarker
public class BatchDeploymentArgsBuilder internal constructor() {
    private var codeConfiguration: Output<CodeConfigurationArgs>? = null

    private var compute: Output<String>? = null

    private var description: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var environmentVariables: Output<Map<String, String>>? = null

    private var errorThreshold: Output<Int>? = null

    private var loggingLevel: Output<Either<String, BatchLoggingLevel>>? = null

    private var maxConcurrencyPerInstance: Output<Int>? = null

    private var miniBatchSize: Output<Double>? = null

    private var model: Output<Any>? = null

    private var outputAction: Output<Either<String, BatchOutputAction>>? = null

    private var outputFileName: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var resources: Output<DeploymentResourceConfigurationArgs>? = null

    private var retrySettings: Output<BatchRetrySettingsArgs>? = null

    /**
     * @param value Code configuration for the endpoint deployment.
     */
    @JvmName("oubfhsrqnabdtvjl")
    public suspend fun codeConfiguration(`value`: Output<CodeConfigurationArgs>) {
        this.codeConfiguration = value
    }

    /**
     * @param value Compute target for batch inference operation.
     */
    @JvmName("myamgdyqhwmowjmn")
    public suspend fun compute(`value`: Output<String>) {
        this.compute = value
    }

    /**
     * @param value Description of the endpoint deployment.
     */
    @JvmName("debmkebeqjukdowq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ARM resource ID or AssetId of the environment specification for the endpoint deployment.
     */
    @JvmName("dxhoufuovrytomuj")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value Environment variables configuration for the deployment.
     */
    @JvmName("pbelokvwvahaegmm")
    public suspend fun environmentVariables(`value`: Output<Map<String, String>>) {
        this.environmentVariables = value
    }

    /**
     * @param value Error threshold, if the error count for the entire input goes above this value,
     * the batch inference will be aborted. Range is [-1, int&#46;MaxValue].
     * For FileDataset, this value is the count of file failures.
     * For TabularDataset, this value is the count of record failures.
     * If set to -1 (the lower bound), all failures during batch inference will be ignored.
     */
    @JvmName("yhfdwltedtsklhge")
    public suspend fun errorThreshold(`value`: Output<Int>) {
        this.errorThreshold = value
    }

    /**
     * @param value Logging level for batch inference operation.
     */
    @JvmName("gdumjrebxgtuedtk")
    public suspend fun loggingLevel(`value`: Output<Either<String, BatchLoggingLevel>>) {
        this.loggingLevel = value
    }

    /**
     * @param value Indicates maximum number of parallelism per instance.
     */
    @JvmName("fbrnjtnrtummvnur")
    public suspend fun maxConcurrencyPerInstance(`value`: Output<Int>) {
        this.maxConcurrencyPerInstance = value
    }

    /**
     * @param value Size of the mini-batch passed to each batch invocation.
     * For FileDataset, this is the number of files per mini-batch.
     * For TabularDataset, this is the size of the records in bytes, per mini-batch.
     */
    @JvmName("avnbhumtjojgxgeh")
    public suspend fun miniBatchSize(`value`: Output<Double>) {
        this.miniBatchSize = value
    }

    /**
     * @param value Reference to the model asset for the endpoint deployment.
     */
    @JvmName("qgsamfikkldcehut")
    public suspend fun model(`value`: Output<Any>) {
        this.model = value
    }

    /**
     * @param value Indicates how the output will be organized.
     */
    @JvmName("bydisjsrrisexoax")
    public suspend fun outputAction(`value`: Output<Either<String, BatchOutputAction>>) {
        this.outputAction = value
    }

    /**
     * @param value Customized output file name for append_row output action.
     */
    @JvmName("uwierqddcibplbuh")
    public suspend fun outputFileName(`value`: Output<String>) {
        this.outputFileName = value
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("sptfhfdmyhcqxsty")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Indicates compute configuration for the job.
     * If not provided, will default to the defaults defined in ResourceConfiguration.
     */
    @JvmName("givuottvshgkujke")
    public suspend fun resources(`value`: Output<DeploymentResourceConfigurationArgs>) {
        this.resources = value
    }

    /**
     * @param value Retry Settings for the batch inference operation.
     * If not provided, will default to the defaults defined in BatchRetrySettings.
     */
    @JvmName("bupgsotuepmfmiir")
    public suspend fun retrySettings(`value`: Output<BatchRetrySettingsArgs>) {
        this.retrySettings = value
    }

    /**
     * @param value Code configuration for the endpoint deployment.
     */
    @JvmName("anhmfqvfqqauhlce")
    public suspend fun codeConfiguration(`value`: CodeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeConfiguration = mapped
    }

    /**
     * @param argument Code configuration for the endpoint deployment.
     */
    @JvmName("bcognsdjkmsapcsa")
    public suspend fun codeConfiguration(argument: suspend CodeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CodeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.codeConfiguration = mapped
    }

    /**
     * @param value Compute target for batch inference operation.
     */
    @JvmName("tmglhwsaxiyocaim")
    public suspend fun compute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compute = mapped
    }

    /**
     * @param value Description of the endpoint deployment.
     */
    @JvmName("jngmwukbuotlashe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ARM resource ID or AssetId of the environment specification for the endpoint deployment.
     */
    @JvmName("lcfvfydebnwamhsl")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value Environment variables configuration for the deployment.
     */
    @JvmName("bbdhtivbmkrbpqst")
    public suspend fun environmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param values Environment variables configuration for the deployment.
     */
    @JvmName("luygupqqyjhimpqk")
    public fun environmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Error threshold, if the error count for the entire input goes above this value,
     * the batch inference will be aborted. Range is [-1, int&#46;MaxValue].
     * For FileDataset, this value is the count of file failures.
     * For TabularDataset, this value is the count of record failures.
     * If set to -1 (the lower bound), all failures during batch inference will be ignored.
     */
    @JvmName("anqtsvahvglgtenb")
    public suspend fun errorThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorThreshold = mapped
    }

    /**
     * @param value Logging level for batch inference operation.
     */
    @JvmName("sbdsejlehjnugqdl")
    public suspend fun loggingLevel(`value`: Either<String, BatchLoggingLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value Logging level for batch inference operation.
     */
    @JvmName("mcnowssefbqolala")
    public fun loggingLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BatchLoggingLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value Logging level for batch inference operation.
     */
    @JvmName("hpgrngxiqoixmvcf")
    public fun loggingLevel(`value`: BatchLoggingLevel) {
        val toBeMapped = Either.ofRight<String, BatchLoggingLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value Indicates maximum number of parallelism per instance.
     */
    @JvmName("mfgjkheoqcxbmdya")
    public suspend fun maxConcurrencyPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrencyPerInstance = mapped
    }

    /**
     * @param value Size of the mini-batch passed to each batch invocation.
     * For FileDataset, this is the number of files per mini-batch.
     * For TabularDataset, this is the size of the records in bytes, per mini-batch.
     */
    @JvmName("oktgyifluytclywg")
    public suspend fun miniBatchSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.miniBatchSize = mapped
    }

    /**
     * @param value Reference to the model asset for the endpoint deployment.
     */
    @JvmName("mwboucpivbsakrwk")
    public suspend fun model(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param value Indicates how the output will be organized.
     */
    @JvmName("haloxthpmdjnurls")
    public suspend fun outputAction(`value`: Either<String, BatchOutputAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputAction = mapped
    }

    /**
     * @param value Indicates how the output will be organized.
     */
    @JvmName("tihamtpbungoynoa")
    public fun outputAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BatchOutputAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputAction = mapped
    }

    /**
     * @param value Indicates how the output will be organized.
     */
    @JvmName("odskxeyvmbesftdp")
    public fun outputAction(`value`: BatchOutputAction) {
        val toBeMapped = Either.ofRight<String, BatchOutputAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputAction = mapped
    }

    /**
     * @param value Customized output file name for append_row output action.
     */
    @JvmName("rlqdjffwpekmpcdi")
    public suspend fun outputFileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputFileName = mapped
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("mgaspnfyhsfpsdex")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("haufecwldnuofyge")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Indicates compute configuration for the job.
     * If not provided, will default to the defaults defined in ResourceConfiguration.
     */
    @JvmName("snrmublanmcxrqjp")
    public suspend fun resources(`value`: DeploymentResourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Indicates compute configuration for the job.
     * If not provided, will default to the defaults defined in ResourceConfiguration.
     */
    @JvmName("jaffuiqacxxmtjco")
    public suspend
    fun resources(argument: suspend DeploymentResourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentResourceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value Retry Settings for the batch inference operation.
     * If not provided, will default to the defaults defined in BatchRetrySettings.
     */
    @JvmName("axrxbbjhnffxcklq")
    public suspend fun retrySettings(`value`: BatchRetrySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retrySettings = mapped
    }

    /**
     * @param argument Retry Settings for the batch inference operation.
     * If not provided, will default to the defaults defined in BatchRetrySettings.
     */
    @JvmName("qoefukvqutsmidas")
    public suspend fun retrySettings(argument: suspend BatchRetrySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = BatchRetrySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retrySettings = mapped
    }

    internal fun build(): BatchDeploymentArgs = BatchDeploymentArgs(
        codeConfiguration = codeConfiguration,
        compute = compute,
        description = description,
        environmentId = environmentId,
        environmentVariables = environmentVariables,
        errorThreshold = errorThreshold,
        loggingLevel = loggingLevel,
        maxConcurrencyPerInstance = maxConcurrencyPerInstance,
        miniBatchSize = miniBatchSize,
        model = model,
        outputAction = outputAction,
        outputFileName = outputFileName,
        properties = properties,
        resources = resources,
        retrySettings = retrySettings,
    )
}
