@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.BatchRetrySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Retry settings for a batch inference operation.
 * @property maxRetries Maximum retry count for a mini-batch
 * @property timeout Invocation timeout for a mini-batch, in ISO 8601 format.
 */
public data class BatchRetrySettingsArgs(
    public val maxRetries: Output<Int>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.BatchRetrySettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.BatchRetrySettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.BatchRetrySettingsArgs.builder()
            .maxRetries(maxRetries?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BatchRetrySettingsArgs].
 */
@PulumiTagMarker
public class BatchRetrySettingsArgsBuilder internal constructor() {
    private var maxRetries: Output<Int>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value Maximum retry count for a mini-batch
     */
    @JvmName("tcnoroofrleuwpnm")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value Invocation timeout for a mini-batch, in ISO 8601 format.
     */
    @JvmName("fopkrfudrrikwcur")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value Maximum retry count for a mini-batch
     */
    @JvmName("gffygkpikkjytkyd")
    public suspend fun maxRetries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value Invocation timeout for a mini-batch, in ISO 8601 format.
     */
    @JvmName("oncnnoqrokgdehlc")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): BatchRetrySettingsArgs = BatchRetrySettingsArgs(
        maxRetries = maxRetries,
        timeout = timeout,
    )
}
