@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CapacityReservationGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property offer Offer used by this capacity reservation group.
 * @property reservedCapacity [Required] Specifies the amount of capacity to reserve.
 */
public data class CapacityReservationGroupArgs(
    public val offer: Output<ServerlessOfferArgs>? = null,
    public val reservedCapacity: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CapacityReservationGroupArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.CapacityReservationGroupArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CapacityReservationGroupArgs.builder()
            .offer(offer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .reservedCapacity(reservedCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CapacityReservationGroupArgs].
 */
@PulumiTagMarker
public class CapacityReservationGroupArgsBuilder internal constructor() {
    private var offer: Output<ServerlessOfferArgs>? = null

    private var reservedCapacity: Output<Int>? = null

    /**
     * @param value Offer used by this capacity reservation group.
     */
    @JvmName("tyvdmkbvuvcepfwa")
    public suspend fun offer(`value`: Output<ServerlessOfferArgs>) {
        this.offer = value
    }

    /**
     * @param value [Required] Specifies the amount of capacity to reserve.
     */
    @JvmName("iugwooilkcowpsli")
    public suspend fun reservedCapacity(`value`: Output<Int>) {
        this.reservedCapacity = value
    }

    /**
     * @param value Offer used by this capacity reservation group.
     */
    @JvmName("whqsocntxkihudsi")
    public suspend fun offer(`value`: ServerlessOfferArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offer = mapped
    }

    /**
     * @param argument Offer used by this capacity reservation group.
     */
    @JvmName("wioojuxmwuxpdnkl")
    public suspend fun offer(argument: suspend ServerlessOfferArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessOfferArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.offer = mapped
    }

    /**
     * @param value [Required] Specifies the amount of capacity to reserve.
     */
    @JvmName("pcrprpnfitpfeejo")
    public suspend fun reservedCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedCapacity = mapped
    }

    internal fun build(): CapacityReservationGroupArgs = CapacityReservationGroupArgs(
        offer = offer,
        reservedCapacity = reservedCapacity ?: throw PulumiNullFieldException("reservedCapacity"),
    )
}
