@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CustomSeasonalityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mode Forecasting seasonality mode.
 * Expected value is 'Custom'.
 * @property value [Required] Seasonality value.
 */
public data class CustomSeasonalityArgs(
    public val mode: Output<String>,
    public val `value`: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CustomSeasonalityArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CustomSeasonalityArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CustomSeasonalityArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomSeasonalityArgs].
 */
@PulumiTagMarker
public class CustomSeasonalityArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value Forecasting seasonality mode.
     * Expected value is 'Custom'.
     */
    @JvmName("tguxmtqdxbccwbba")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value [Required] Seasonality value.
     */
    @JvmName("dcwifddjqngxshrm")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value Forecasting seasonality mode.
     * Expected value is 'Custom'.
     */
    @JvmName("insexjskpivoouns")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value [Required] Seasonality value.
     */
    @JvmName("dvitiexihcfhfmbv")
    public suspend fun `value`(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): CustomSeasonalityArgs = CustomSeasonalityArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
