@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.CustomTargetLagsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property mode Target lags selection modes.
 * Expected value is 'Custom'.
 * @property values [Required] Set target lags values.
 */
public data class CustomTargetLagsArgs(
    public val mode: Output<String>,
    public val values: Output<List<Int>>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.CustomTargetLagsArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.CustomTargetLagsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.CustomTargetLagsArgs.builder()
            .mode(mode.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CustomTargetLagsArgs].
 */
@PulumiTagMarker
public class CustomTargetLagsArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    private var values: Output<List<Int>>? = null

    /**
     * @param value Target lags selection modes.
     * Expected value is 'Custom'.
     */
    @JvmName("gdvtcwloimeyrqoi")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value [Required] Set target lags values.
     */
    @JvmName("elruwupxwhkxogwo")
    public suspend fun values(`value`: Output<List<Int>>) {
        this.values = value
    }

    @JvmName("cvgqyiptlrwycgjr")
    public suspend fun values(vararg values: Output<Int>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values [Required] Set target lags values.
     */
    @JvmName("anrtgnfbxdfhwftw")
    public suspend fun values(values: List<Output<Int>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Target lags selection modes.
     * Expected value is 'Custom'.
     */
    @JvmName("qgghjcfochuocsjo")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value [Required] Set target lags values.
     */
    @JvmName("yvpubfvxbocqvtch")
    public suspend fun values(`value`: List<Int>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values [Required] Set target lags values.
     */
    @JvmName("gcupcbiijkwtejmw")
    public suspend fun values(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): CustomTargetLagsArgs = CustomTargetLagsArgs(
        mode = mode ?: throw PulumiNullFieldException("mode"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
