@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DataPathAssetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to an asset via its path in a datastore.
 * @property datastoreId ARM resource ID of the datastore where the asset is located.
 * @property path The path of the file/directory in the datastore.
 * @property referenceType Enum to determine which reference method to use for an asset.
 * Expected value is 'DataPath'.
 */
public data class DataPathAssetReferenceArgs(
    public val datastoreId: Output<String>? = null,
    public val path: Output<String>? = null,
    public val referenceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DataPathAssetReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DataPathAssetReferenceArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DataPathAssetReferenceArgs.builder()
            .datastoreId(datastoreId?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .referenceType(referenceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataPathAssetReferenceArgs].
 */
@PulumiTagMarker
public class DataPathAssetReferenceArgsBuilder internal constructor() {
    private var datastoreId: Output<String>? = null

    private var path: Output<String>? = null

    private var referenceType: Output<String>? = null

    /**
     * @param value ARM resource ID of the datastore where the asset is located.
     */
    @JvmName("jvfrutxjcsnnibyw")
    public suspend fun datastoreId(`value`: Output<String>) {
        this.datastoreId = value
    }

    /**
     * @param value The path of the file/directory in the datastore.
     */
    @JvmName("hejramnbrxtekhim")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Enum to determine which reference method to use for an asset.
     * Expected value is 'DataPath'.
     */
    @JvmName("phppxngaytpdekex")
    public suspend fun referenceType(`value`: Output<String>) {
        this.referenceType = value
    }

    /**
     * @param value ARM resource ID of the datastore where the asset is located.
     */
    @JvmName("tdsegeowuoyuaoov")
    public suspend fun datastoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreId = mapped
    }

    /**
     * @param value The path of the file/directory in the datastore.
     */
    @JvmName("tefvamevlswolssy")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Enum to determine which reference method to use for an asset.
     * Expected value is 'DataPath'.
     */
    @JvmName("svgqqsfargafvtuc")
    public suspend fun referenceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceType = mapped
    }

    internal fun build(): DataPathAssetReferenceArgs = DataPathAssetReferenceArgs(
        datastoreId = datastoreId,
        path = path,
        referenceType = referenceType ?: throw PulumiNullFieldException("referenceType"),
    )
}
