@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DatabricksPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of Databricks
 * @property databricksAccessToken Databricks access token
 * @property workspaceUrl Workspace Url
 */
public data class DatabricksPropertiesArgs(
    public val databricksAccessToken: Output<String>? = null,
    public val workspaceUrl: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DatabricksPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DatabricksPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DatabricksPropertiesArgs.builder()
            .databricksAccessToken(databricksAccessToken?.applyValue({ args0 -> args0 }))
            .workspaceUrl(workspaceUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabricksPropertiesArgs].
 */
@PulumiTagMarker
public class DatabricksPropertiesArgsBuilder internal constructor() {
    private var databricksAccessToken: Output<String>? = null

    private var workspaceUrl: Output<String>? = null

    /**
     * @param value Databricks access token
     */
    @JvmName("uskhtmhpgtdhtvih")
    public suspend fun databricksAccessToken(`value`: Output<String>) {
        this.databricksAccessToken = value
    }

    /**
     * @param value Workspace Url
     */
    @JvmName("bxjjnvckmjqnbqfb")
    public suspend fun workspaceUrl(`value`: Output<String>) {
        this.workspaceUrl = value
    }

    /**
     * @param value Databricks access token
     */
    @JvmName("mwrgnxlpkkjfxqwq")
    public suspend fun databricksAccessToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databricksAccessToken = mapped
    }

    /**
     * @param value Workspace Url
     */
    @JvmName("cbwrbqieqiapfnca")
    public suspend fun workspaceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceUrl = mapped
    }

    internal fun build(): DatabricksPropertiesArgs = DatabricksPropertiesArgs(
        databricksAccessToken = databricksAccessToken,
        workspaceUrl = workspaceUrl,
    )
}
