@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property datastoreName The SQL/PostgreSQL/MySQL datastore name.
 * @property query SQL Quey.
 */
public data class DatasetCreateRequestQueryArgs(
    public val datastoreName: Output<String>? = null,
    public val query: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestQueryArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestQueryArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DatasetCreateRequestQueryArgs.builder()
            .datastoreName(datastoreName?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetCreateRequestQueryArgs].
 */
@PulumiTagMarker
public class DatasetCreateRequestQueryArgsBuilder internal constructor() {
    private var datastoreName: Output<String>? = null

    private var query: Output<String>? = null

    /**
     * @param value The SQL/PostgreSQL/MySQL datastore name.
     */
    @JvmName("skwonckqyiiiluga")
    public suspend fun datastoreName(`value`: Output<String>) {
        this.datastoreName = value
    }

    /**
     * @param value SQL Quey.
     */
    @JvmName("bcmcedfacwdpaduh")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The SQL/PostgreSQL/MySQL datastore name.
     */
    @JvmName("bgkoyqhfjoyogviu")
    public suspend fun datastoreName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datastoreName = mapped
    }

    /**
     * @param value SQL Quey.
     */
    @JvmName("mapigtoelhsvgpyc")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    internal fun build(): DatasetCreateRequestQueryArgs = DatasetCreateRequestQueryArgs(
        datastoreName = datastoreName,
        query = query,
    )
}
