@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.DockerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Docker container configuration
 * @property privileged Indicate whether container shall run in privileged or non-privileged mode.
 */
public data class DockerArgs(
    public val privileged: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.DockerArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.DockerArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.DockerArgs.builder()
            .privileged(privileged?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DockerArgs].
 */
@PulumiTagMarker
public class DockerArgsBuilder internal constructor() {
    private var privileged: Output<Boolean>? = null

    /**
     * @param value Indicate whether container shall run in privileged or non-privileged mode.
     */
    @JvmName("cnffidnechmcsgrd")
    public suspend fun privileged(`value`: Output<Boolean>) {
        this.privileged = value
    }

    /**
     * @param value Indicate whether container shall run in privileged or non-privileged mode.
     */
    @JvmName("hdhgbovdckahcoot")
    public suspend fun privileged(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privileged = mapped
    }

    internal fun build(): DockerArgs = DockerArgs(
        privileged = privileged,
    )
}
