@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.EndpointScheduleActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property actionType
 * Expected value is 'InvokeBatchEndpoint'.
 * @property endpointInvocationDefinition [Required] Defines Schedule action definition details.
 * <see href="TBD" />
 */
public data class EndpointScheduleActionArgs(
    public val actionType: Output<String>,
    public val endpointInvocationDefinition: Output<Any>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.EndpointScheduleActionArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.EndpointScheduleActionArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.EndpointScheduleActionArgs.builder()
            .actionType(actionType.applyValue({ args0 -> args0 }))
            .endpointInvocationDefinition(endpointInvocationDefinition.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointScheduleActionArgs].
 */
@PulumiTagMarker
public class EndpointScheduleActionArgsBuilder internal constructor() {
    private var actionType: Output<String>? = null

    private var endpointInvocationDefinition: Output<Any>? = null

    /**
     * @param value
     * Expected value is 'InvokeBatchEndpoint'.
     */
    @JvmName("ajgikenppddaeppp")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value [Required] Defines Schedule action definition details.
     * <see href="TBD" />
     */
    @JvmName("eknbwmqclklcpabi")
    public suspend fun endpointInvocationDefinition(`value`: Output<Any>) {
        this.endpointInvocationDefinition = value
    }

    /**
     * @param value
     * Expected value is 'InvokeBatchEndpoint'.
     */
    @JvmName("jucimgwmryhpobfa")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value [Required] Defines Schedule action definition details.
     * <see href="TBD" />
     */
    @JvmName("xvqmtwkhuyvpdvlu")
    public suspend fun endpointInvocationDefinition(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointInvocationDefinition = mapped
    }

    internal fun build(): EndpointScheduleActionArgs = EndpointScheduleActionArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        endpointInvocationDefinition = endpointInvocationDefinition ?: throw
            PulumiNullFieldException("endpointInvocationDefinition"),
    )
}
