@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.ForecastingTrainingSettingsArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ForecastingModels
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Forecasting Training related configuration.
 * @property allowedTrainingAlgorithms Allowed models for forecasting task.
 * @property blockedTrainingAlgorithms Blocked models for forecasting task.
 * @property enableDnnTraining Enable recommendation of DNN models.
 * @property enableModelExplainability Flag to turn on explainability on best model.
 * @property enableOnnxCompatibleModels Flag for enabling onnx compatible models.
 * @property enableStackEnsemble Enable stack ensemble run.
 * @property enableVoteEnsemble Enable voting ensemble run.
 * @property ensembleModelDownloadTimeout During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
 * Configure this parameter with a higher value than 300 secs, if more time is needed.
 * @property stackEnsembleSettings Stack ensemble settings for stack ensemble run.
 */
public data class ForecastingTrainingSettingsArgs(
    public val allowedTrainingAlgorithms: Output<List<Either<String, ForecastingModels>>>? = null,
    public val blockedTrainingAlgorithms: Output<List<Either<String, ForecastingModels>>>? = null,
    public val enableDnnTraining: Output<Boolean>? = null,
    public val enableModelExplainability: Output<Boolean>? = null,
    public val enableOnnxCompatibleModels: Output<Boolean>? = null,
    public val enableStackEnsemble: Output<Boolean>? = null,
    public val enableVoteEnsemble: Output<Boolean>? = null,
    public val ensembleModelDownloadTimeout: Output<String>? = null,
    public val stackEnsembleSettings: Output<StackEnsembleSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.ForecastingTrainingSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.ForecastingTrainingSettingsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.ForecastingTrainingSettingsArgs.builder()
            .allowedTrainingAlgorithms(
                allowedTrainingAlgorithms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .blockedTrainingAlgorithms(
                blockedTrainingAlgorithms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .enableDnnTraining(enableDnnTraining?.applyValue({ args0 -> args0 }))
            .enableModelExplainability(enableModelExplainability?.applyValue({ args0 -> args0 }))
            .enableOnnxCompatibleModels(enableOnnxCompatibleModels?.applyValue({ args0 -> args0 }))
            .enableStackEnsemble(enableStackEnsemble?.applyValue({ args0 -> args0 }))
            .enableVoteEnsemble(enableVoteEnsemble?.applyValue({ args0 -> args0 }))
            .ensembleModelDownloadTimeout(ensembleModelDownloadTimeout?.applyValue({ args0 -> args0 }))
            .stackEnsembleSettings(
                stackEnsembleSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ForecastingTrainingSettingsArgs].
 */
@PulumiTagMarker
public class ForecastingTrainingSettingsArgsBuilder internal constructor() {
    private var allowedTrainingAlgorithms: Output<List<Either<String, ForecastingModels>>>? = null

    private var blockedTrainingAlgorithms: Output<List<Either<String, ForecastingModels>>>? = null

    private var enableDnnTraining: Output<Boolean>? = null

    private var enableModelExplainability: Output<Boolean>? = null

    private var enableOnnxCompatibleModels: Output<Boolean>? = null

    private var enableStackEnsemble: Output<Boolean>? = null

    private var enableVoteEnsemble: Output<Boolean>? = null

    private var ensembleModelDownloadTimeout: Output<String>? = null

    private var stackEnsembleSettings: Output<StackEnsembleSettingsArgs>? = null

    /**
     * @param value Allowed models for forecasting task.
     */
    @JvmName("mfwrowfpsnfdoxay")
    public suspend
    fun allowedTrainingAlgorithms(`value`: Output<List<Either<String, ForecastingModels>>>) {
        this.allowedTrainingAlgorithms = value
    }

    @JvmName("urqgaaxpypghwjdd")
    public suspend fun allowedTrainingAlgorithms(
        vararg
        values: Output<Either<String, ForecastingModels>>,
    ) {
        this.allowedTrainingAlgorithms = Output.all(values.asList())
    }

    /**
     * @param values Allowed models for forecasting task.
     */
    @JvmName("rmfflgecvnrkyotm")
    public suspend
    fun allowedTrainingAlgorithms(values: List<Output<Either<String, ForecastingModels>>>) {
        this.allowedTrainingAlgorithms = Output.all(values)
    }

    /**
     * @param value Blocked models for forecasting task.
     */
    @JvmName("noisnvxxdbakbmnj")
    public suspend
    fun blockedTrainingAlgorithms(`value`: Output<List<Either<String, ForecastingModels>>>) {
        this.blockedTrainingAlgorithms = value
    }

    @JvmName("jgxaqmktfypvqvda")
    public suspend fun blockedTrainingAlgorithms(
        vararg
        values: Output<Either<String, ForecastingModels>>,
    ) {
        this.blockedTrainingAlgorithms = Output.all(values.asList())
    }

    /**
     * @param values Blocked models for forecasting task.
     */
    @JvmName("uukdqkhqcyngidvw")
    public suspend
    fun blockedTrainingAlgorithms(values: List<Output<Either<String, ForecastingModels>>>) {
        this.blockedTrainingAlgorithms = Output.all(values)
    }

    /**
     * @param value Enable recommendation of DNN models.
     */
    @JvmName("bvaxfptxipdjqgxx")
    public suspend fun enableDnnTraining(`value`: Output<Boolean>) {
        this.enableDnnTraining = value
    }

    /**
     * @param value Flag to turn on explainability on best model.
     */
    @JvmName("rjrxpfhyyepjesro")
    public suspend fun enableModelExplainability(`value`: Output<Boolean>) {
        this.enableModelExplainability = value
    }

    /**
     * @param value Flag for enabling onnx compatible models.
     */
    @JvmName("jxxrayslgawppawg")
    public suspend fun enableOnnxCompatibleModels(`value`: Output<Boolean>) {
        this.enableOnnxCompatibleModels = value
    }

    /**
     * @param value Enable stack ensemble run.
     */
    @JvmName("pctcjvbvpulabdqe")
    public suspend fun enableStackEnsemble(`value`: Output<Boolean>) {
        this.enableStackEnsemble = value
    }

    /**
     * @param value Enable voting ensemble run.
     */
    @JvmName("junkxeevjllsyycn")
    public suspend fun enableVoteEnsemble(`value`: Output<Boolean>) {
        this.enableVoteEnsemble = value
    }

    /**
     * @param value During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
     * Configure this parameter with a higher value than 300 secs, if more time is needed.
     */
    @JvmName("iruteudbrcjkwgmq")
    public suspend fun ensembleModelDownloadTimeout(`value`: Output<String>) {
        this.ensembleModelDownloadTimeout = value
    }

    /**
     * @param value Stack ensemble settings for stack ensemble run.
     */
    @JvmName("rvkqldioemdcfftr")
    public suspend fun stackEnsembleSettings(`value`: Output<StackEnsembleSettingsArgs>) {
        this.stackEnsembleSettings = value
    }

    /**
     * @param value Allowed models for forecasting task.
     */
    @JvmName("jvoyunvtvoidseqr")
    public suspend fun allowedTrainingAlgorithms(`value`: List<Either<String, ForecastingModels>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedTrainingAlgorithms = mapped
    }

    /**
     * @param values Allowed models for forecasting task.
     */
    @JvmName("ewoxvtpettexynle")
    public suspend fun allowedTrainingAlgorithms(vararg values: Either<String, ForecastingModels>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedTrainingAlgorithms = mapped
    }

    /**
     * @param value Blocked models for forecasting task.
     */
    @JvmName("ijdwhdqpqqwcorqm")
    public suspend fun blockedTrainingAlgorithms(`value`: List<Either<String, ForecastingModels>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockedTrainingAlgorithms = mapped
    }

    /**
     * @param values Blocked models for forecasting task.
     */
    @JvmName("daxfvvvcqtypxqxp")
    public suspend fun blockedTrainingAlgorithms(vararg values: Either<String, ForecastingModels>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockedTrainingAlgorithms = mapped
    }

    /**
     * @param value Enable recommendation of DNN models.
     */
    @JvmName("ohoswhbjjablglel")
    public suspend fun enableDnnTraining(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDnnTraining = mapped
    }

    /**
     * @param value Flag to turn on explainability on best model.
     */
    @JvmName("emulpplomofrnsxs")
    public suspend fun enableModelExplainability(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableModelExplainability = mapped
    }

    /**
     * @param value Flag for enabling onnx compatible models.
     */
    @JvmName("scsdiotitvnvbpad")
    public suspend fun enableOnnxCompatibleModels(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOnnxCompatibleModels = mapped
    }

    /**
     * @param value Enable stack ensemble run.
     */
    @JvmName("tlyhfqcqdgudrfyj")
    public suspend fun enableStackEnsemble(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableStackEnsemble = mapped
    }

    /**
     * @param value Enable voting ensemble run.
     */
    @JvmName("tsobvknaihiwqtwp")
    public suspend fun enableVoteEnsemble(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableVoteEnsemble = mapped
    }

    /**
     * @param value During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
     * Configure this parameter with a higher value than 300 secs, if more time is needed.
     */
    @JvmName("wsljxelqkugywxmp")
    public suspend fun ensembleModelDownloadTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ensembleModelDownloadTimeout = mapped
    }

    /**
     * @param value Stack ensemble settings for stack ensemble run.
     */
    @JvmName("obfbsnrufkvrjbvk")
    public suspend fun stackEnsembleSettings(`value`: StackEnsembleSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stackEnsembleSettings = mapped
    }

    /**
     * @param argument Stack ensemble settings for stack ensemble run.
     */
    @JvmName("kwvjhthjheitxfse")
    public suspend
    fun stackEnsembleSettings(argument: suspend StackEnsembleSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StackEnsembleSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.stackEnsembleSettings = mapped
    }

    internal fun build(): ForecastingTrainingSettingsArgs = ForecastingTrainingSettingsArgs(
        allowedTrainingAlgorithms = allowedTrainingAlgorithms,
        blockedTrainingAlgorithms = blockedTrainingAlgorithms,
        enableDnnTraining = enableDnnTraining,
        enableModelExplainability = enableModelExplainability,
        enableOnnxCompatibleModels = enableOnnxCompatibleModels,
        enableStackEnsemble = enableStackEnsemble,
        enableVoteEnsemble = enableVoteEnsemble,
        ensembleModelDownloadTimeout = ensembleModelDownloadTimeout,
        stackEnsembleSettings = stackEnsembleSettings,
    )
}
