@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.FqdnOutboundRuleArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RuleCategory
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.RuleStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * FQDN Outbound Rule for the managed network of a machine learning workspace.
 * @property category Category of a managed network Outbound Rule of a machine learning workspace.
 * @property destination
 * @property status Status of a managed network Outbound Rule of a machine learning workspace.
 * @property type Type of a managed network Outbound Rule of a machine learning workspace.
 * Expected value is 'FQDN'.
 */
public data class FqdnOutboundRuleArgs(
    public val category: Output<Either<String, RuleCategory>>? = null,
    public val destination: Output<String>? = null,
    public val status: Output<Either<String, RuleStatus>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.FqdnOutboundRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.FqdnOutboundRuleArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.FqdnOutboundRuleArgs.builder()
            .category(
                category?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .destination(destination?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FqdnOutboundRuleArgs].
 */
@PulumiTagMarker
public class FqdnOutboundRuleArgsBuilder internal constructor() {
    private var category: Output<Either<String, RuleCategory>>? = null

    private var destination: Output<String>? = null

    private var status: Output<Either<String, RuleStatus>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("dpcvuspoymtuaauv")
    public suspend fun category(`value`: Output<Either<String, RuleCategory>>) {
        this.category = value
    }

    /**
     * @param value
     */
    @JvmName("fhxapymwveskvatg")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("agknbdajryubsqjq")
    public suspend fun status(`value`: Output<Either<String, RuleStatus>>) {
        this.status = value
    }

    /**
     * @param value Type of a managed network Outbound Rule of a machine learning workspace.
     * Expected value is 'FQDN'.
     */
    @JvmName("ppfldntgqlmxgjjl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("xbmjmogntunycbpm")
    public suspend fun category(`value`: Either<String, RuleCategory>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("lbbpdeiatpppydni")
    public fun category(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value Category of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("uvpetwiruqdlnvtd")
    public fun category(`value`: RuleCategory) {
        val toBeMapped = Either.ofRight<String, RuleCategory>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value
     */
    @JvmName("pklmkwubsokcnltf")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("icjpuhxuhcgbuafh")
    public suspend fun status(`value`: Either<String, RuleStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("rncjoffjccstfxuy")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of a managed network Outbound Rule of a machine learning workspace.
     */
    @JvmName("minidnkdtbbbmbrv")
    public fun status(`value`: RuleStatus) {
        val toBeMapped = Either.ofRight<String, RuleStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Type of a managed network Outbound Rule of a machine learning workspace.
     * Expected value is 'FQDN'.
     */
    @JvmName("ymawlsgystvuakcp")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FqdnOutboundRuleArgs = FqdnOutboundRuleArgs(
        category = category,
        destination = destination,
        status = status,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
