@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetLabelingJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The name and identifier for the LabelingJob.
 * @property includeJobInstructions Boolean value to indicate whether to include JobInstructions in response.
 * @property includeLabelCategories Boolean value to indicate Whether to include LabelCategories in response.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName Name of Azure Machine Learning workspace.
 */
public data class GetLabelingJobPlainArgs(
    public val id: String,
    public val includeJobInstructions: Boolean? = null,
    public val includeLabelCategories: Boolean? = null,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetLabelingJobPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetLabelingJobPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetLabelingJobPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .includeJobInstructions(includeJobInstructions?.let({ args0 -> args0 }))
            .includeLabelCategories(includeLabelCategories?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLabelingJobPlainArgs].
 */
@PulumiTagMarker
public class GetLabelingJobPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var includeJobInstructions: Boolean? = null

    private var includeLabelCategories: Boolean? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name and identifier for the LabelingJob.
     */
    @JvmName("wilhclyjopjyluki")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Boolean value to indicate whether to include JobInstructions in response.
     */
    @JvmName("pdlmcvgecsyxgucy")
    public suspend fun includeJobInstructions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeJobInstructions = mapped
    }

    /**
     * @param value Boolean value to indicate Whether to include LabelCategories in response.
     */
    @JvmName("mdpgfpdoxuuuctoy")
    public suspend fun includeLabelCategories(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeLabelCategories = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hkoixpcwolslersu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning workspace.
     */
    @JvmName("gdqdvrgoejosvohr")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetLabelingJobPlainArgs = GetLabelingJobPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        includeJobInstructions = includeJobInstructions,
        includeLabelCategories = includeLabelCategories,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
