@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryCodeContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property codeName Container name.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRegistryCodeContainerPlainArgs(
    public val codeName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryCodeContainerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryCodeContainerPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryCodeContainerPlainArgs.builder()
            .codeName(codeName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryCodeContainerPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryCodeContainerPlainArgsBuilder internal constructor() {
    private var codeName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Container name.
     */
    @JvmName("vrfacdryhwotdodo")
    public suspend fun codeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.codeName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("pnlsjtypjmjdkxlh")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("chqurxnjcqslixgb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRegistryCodeContainerPlainArgs = GetRegistryCodeContainerPlainArgs(
        codeName = codeName ?: throw PulumiNullFieldException("codeName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
