@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryModelContainerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property modelName Container name. This is case-sensitive.
 * @property registryName Name of Azure Machine Learning registry. This is case-insensitive
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRegistryModelContainerPlainArgs(
    public val modelName: String,
    public val registryName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryModelContainerPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryModelContainerPlainArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.GetRegistryModelContainerPlainArgs.builder()
            .modelName(modelName.let({ args0 -> args0 }))
            .registryName(registryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistryModelContainerPlainArgs].
 */
@PulumiTagMarker
public class GetRegistryModelContainerPlainArgsBuilder internal constructor() {
    private var modelName: String? = null

    private var registryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Container name. This is case-sensitive.
     */
    @JvmName("quewqayfrxtrlwvo")
    public suspend fun modelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.modelName = mapped
    }

    /**
     * @param value Name of Azure Machine Learning registry. This is case-insensitive
     */
    @JvmName("mfpbfwewqjlvsvwx")
    public suspend fun registryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registryName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hftanbweoxhptjmo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRegistryModelContainerPlainArgs = GetRegistryModelContainerPlainArgs(
        modelName = modelName ?: throw PulumiNullFieldException("modelName"),
        registryName = registryName ?: throw PulumiNullFieldException("registryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
