@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.InferenceEndpointArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.AuthMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * InferenceEndpoint configuration
 * @property authMode [Required] Authentication mode for the endpoint.
 * @property description Description of the resource.
 * @property groupId [Required] Group within the same pool with which this endpoint needs to be associated with.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 */
public data class InferenceEndpointArgs(
    public val authMode: Output<Either<String, AuthMode>>,
    public val description: Output<String>? = null,
    public val groupId: Output<String>,
    public val properties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.InferenceEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.InferenceEndpointArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.InferenceEndpointArgs.builder()
            .authMode(
                authMode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .groupId(groupId.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [InferenceEndpointArgs].
 */
@PulumiTagMarker
public class InferenceEndpointArgsBuilder internal constructor() {
    private var authMode: Output<Either<String, AuthMode>>? = null

    private var description: Output<String>? = null

    private var groupId: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value [Required] Authentication mode for the endpoint.
     */
    @JvmName("jxakckgqbpotyunv")
    public suspend fun authMode(`value`: Output<Either<String, AuthMode>>) {
        this.authMode = value
    }

    /**
     * @param value Description of the resource.
     */
    @JvmName("hbpddkmkgrfgcstm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value [Required] Group within the same pool with which this endpoint needs to be associated with.
     */
    @JvmName("tkrdaykviolnvhtx")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("fossyvtdtnbsgxsp")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value [Required] Authentication mode for the endpoint.
     */
    @JvmName("vmyujuwqcgilgqbu")
    public suspend fun authMode(`value`: Either<String, AuthMode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value [Required] Authentication mode for the endpoint.
     */
    @JvmName("eiikbgspfmghdyaa")
    public fun authMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value [Required] Authentication mode for the endpoint.
     */
    @JvmName("mpnbbvfalnpcpuih")
    public fun authMode(`value`: AuthMode) {
        val toBeMapped = Either.ofRight<String, AuthMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value Description of the resource.
     */
    @JvmName("qrjmxhpbpkohsmep")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value [Required] Group within the same pool with which this endpoint needs to be associated with.
     */
    @JvmName("sskifaummnvmtavm")
    public suspend fun groupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("ssiixyqmykoegihe")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("leuutliufectrcxk")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): InferenceEndpointArgs = InferenceEndpointArgs(
        authMode = authMode ?: throw PulumiNullFieldException("authMode"),
        description = description,
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        properties = properties,
    )
}
