@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.InferencePoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Inference pool configuration
 * @property codeConfiguration Code configuration for the inference pool.
 * @property description Description of the resource.
 * @property environmentConfiguration EnvironmentConfiguration for the inference pool.
 * @property modelConfiguration ModelConfiguration for the inference pool.
 * @property nodeSkuType [Required] Compute instance type.
 * @property properties Property dictionary. Properties can be added, but not removed or altered.
 * @property requestConfiguration Request configuration for the inference pool.
 */
public data class InferencePoolArgs(
    public val codeConfiguration: Output<CodeConfigurationArgs>? = null,
    public val description: Output<String>? = null,
    public val environmentConfiguration: Output<PoolEnvironmentConfigurationArgs>? = null,
    public val modelConfiguration: Output<PoolModelConfigurationArgs>? = null,
    public val nodeSkuType: Output<String>,
    public val properties: Output<Map<String, String>>? = null,
    public val requestConfiguration: Output<RequestConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.InferencePoolArgs> {
    override fun toJava(): com.pulumi.azurenative.machinelearningservices.inputs.InferencePoolArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.InferencePoolArgs.builder()
            .codeConfiguration(codeConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentConfiguration(
                environmentConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .modelConfiguration(
                modelConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .nodeSkuType(nodeSkuType.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .requestConfiguration(
                requestConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [InferencePoolArgs].
 */
@PulumiTagMarker
public class InferencePoolArgsBuilder internal constructor() {
    private var codeConfiguration: Output<CodeConfigurationArgs>? = null

    private var description: Output<String>? = null

    private var environmentConfiguration: Output<PoolEnvironmentConfigurationArgs>? = null

    private var modelConfiguration: Output<PoolModelConfigurationArgs>? = null

    private var nodeSkuType: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var requestConfiguration: Output<RequestConfigurationArgs>? = null

    /**
     * @param value Code configuration for the inference pool.
     */
    @JvmName("puvsrpykopgpuedl")
    public suspend fun codeConfiguration(`value`: Output<CodeConfigurationArgs>) {
        this.codeConfiguration = value
    }

    /**
     * @param value Description of the resource.
     */
    @JvmName("oelkumtmitgkkyoy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value EnvironmentConfiguration for the inference pool.
     */
    @JvmName("dmlcwjbyatdiyxlc")
    public suspend fun environmentConfiguration(`value`: Output<PoolEnvironmentConfigurationArgs>) {
        this.environmentConfiguration = value
    }

    /**
     * @param value ModelConfiguration for the inference pool.
     */
    @JvmName("jmxlpdrnlgvnvpku")
    public suspend fun modelConfiguration(`value`: Output<PoolModelConfigurationArgs>) {
        this.modelConfiguration = value
    }

    /**
     * @param value [Required] Compute instance type.
     */
    @JvmName("umsnpbtmxjeagysc")
    public suspend fun nodeSkuType(`value`: Output<String>) {
        this.nodeSkuType = value
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("poewsbnuilmkpfcm")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Request configuration for the inference pool.
     */
    @JvmName("llwosuvnsoqacnai")
    public suspend fun requestConfiguration(`value`: Output<RequestConfigurationArgs>) {
        this.requestConfiguration = value
    }

    /**
     * @param value Code configuration for the inference pool.
     */
    @JvmName("puwlfapiduckkbnf")
    public suspend fun codeConfiguration(`value`: CodeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeConfiguration = mapped
    }

    /**
     * @param argument Code configuration for the inference pool.
     */
    @JvmName("unvnuxewibnjjuwy")
    public suspend fun codeConfiguration(argument: suspend CodeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CodeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.codeConfiguration = mapped
    }

    /**
     * @param value Description of the resource.
     */
    @JvmName("wktusyltxlesislp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value EnvironmentConfiguration for the inference pool.
     */
    @JvmName("ybjeuludltyaravk")
    public suspend fun environmentConfiguration(`value`: PoolEnvironmentConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentConfiguration = mapped
    }

    /**
     * @param argument EnvironmentConfiguration for the inference pool.
     */
    @JvmName("ixoxtcyincusyjtl")
    public suspend
    fun environmentConfiguration(argument: suspend PoolEnvironmentConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PoolEnvironmentConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.environmentConfiguration = mapped
    }

    /**
     * @param value ModelConfiguration for the inference pool.
     */
    @JvmName("jtbmpedfwthlivof")
    public suspend fun modelConfiguration(`value`: PoolModelConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelConfiguration = mapped
    }

    /**
     * @param argument ModelConfiguration for the inference pool.
     */
    @JvmName("niieraopoqkonnyv")
    public suspend
    fun modelConfiguration(argument: suspend PoolModelConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = PoolModelConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.modelConfiguration = mapped
    }

    /**
     * @param value [Required] Compute instance type.
     */
    @JvmName("vwroobrlasgeupyj")
    public suspend fun nodeSkuType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nodeSkuType = mapped
    }

    /**
     * @param value Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("povihwgdpwwldqmy")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Property dictionary. Properties can be added, but not removed or altered.
     */
    @JvmName("xchprhijaroxmduo")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Request configuration for the inference pool.
     */
    @JvmName("lxibnoayethfdloa")
    public suspend fun requestConfiguration(`value`: RequestConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestConfiguration = mapped
    }

    /**
     * @param argument Request configuration for the inference pool.
     */
    @JvmName("qhtanhpcutxikiqs")
    public suspend
    fun requestConfiguration(argument: suspend RequestConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RequestConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requestConfiguration = mapped
    }

    internal fun build(): InferencePoolArgs = InferencePoolArgs(
        codeConfiguration = codeConfiguration,
        description = description,
        environmentConfiguration = environmentConfiguration,
        modelConfiguration = modelConfiguration,
        nodeSkuType = nodeSkuType ?: throw PulumiNullFieldException("nodeSkuType"),
        properties = properties,
        requestConfiguration = requestConfiguration,
    )
}
