@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.JobResourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property dockerArgs Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the system, or in this section. This parameter is only supported for Azure ML compute types.
 * @property instanceCount Optional number of instances or nodes used by the compute target.
 * @property instanceType Optional type of VM used as supported by the compute target.
 * @property properties Additional properties bag.
 * @property shmSize Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
 */
public data class JobResourceConfigurationArgs(
    public val dockerArgs: Output<String>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val properties: Output<Map<String, Any>>? = null,
    public val shmSize: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.JobResourceConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.JobResourceConfigurationArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.JobResourceConfigurationArgs.builder()
            .dockerArgs(dockerArgs?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .shmSize(shmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobResourceConfigurationArgs].
 */
@PulumiTagMarker
public class JobResourceConfigurationArgsBuilder internal constructor() {
    private var dockerArgs: Output<String>? = null

    private var instanceCount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var properties: Output<Map<String, Any>>? = null

    private var shmSize: Output<String>? = null

    /**
     * @param value Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the system, or in this section. This parameter is only supported for Azure ML compute types.
     */
    @JvmName("dlsrpgfgfmjhpici")
    public suspend fun dockerArgs(`value`: Output<String>) {
        this.dockerArgs = value
    }

    /**
     * @param value Optional number of instances or nodes used by the compute target.
     */
    @JvmName("qkvyfhcxhfxejhww")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value Optional type of VM used as supported by the compute target.
     */
    @JvmName("ifgedtfqqgwbngtc")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Additional properties bag.
     */
    @JvmName("dainjiegudaxqjyk")
    public suspend fun properties(`value`: Output<Map<String, Any>>) {
        this.properties = value
    }

    /**
     * @param value Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
     */
    @JvmName("fsboffcyyyckujfm")
    public suspend fun shmSize(`value`: Output<String>) {
        this.shmSize = value
    }

    /**
     * @param value Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the system, or in this section. This parameter is only supported for Azure ML compute types.
     */
    @JvmName("fqyefucwgafvrjci")
    public suspend fun dockerArgs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dockerArgs = mapped
    }

    /**
     * @param value Optional number of instances or nodes used by the compute target.
     */
    @JvmName("bjhdtxkjjbivjyun")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value Optional type of VM used as supported by the compute target.
     */
    @JvmName("nqwslslfctxhmoqr")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Additional properties bag.
     */
    @JvmName("blbutbnkffboclrq")
    public suspend fun properties(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Additional properties bag.
     */
    @JvmName("wobnaiqsbsfsgufj")
    public fun properties(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes), or g(gigabytes).
     */
    @JvmName("gdslbfkwtwlmkjbm")
    public suspend fun shmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shmSize = mapped
    }

    internal fun build(): JobResourceConfigurationArgs = JobResourceConfigurationArgs(
        dockerArgs = dockerArgs,
        instanceCount = instanceCount,
        instanceType = instanceType,
        properties = properties,
        shmSize = shmSize,
    )
}
