@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobImagePropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.ImageAnnotationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a labeling job for image data
 * @property annotationType Annotation type of image labeling job.
 * @property mediaType Media type of data asset.
 * Expected value is 'Image'.
 */
public data class LabelingJobImagePropertiesArgs(
    public val annotationType: Output<Either<String, ImageAnnotationType>>? = null,
    public val mediaType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobImagePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobImagePropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobImagePropertiesArgs.builder()
            .annotationType(
                annotationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .mediaType(mediaType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabelingJobImagePropertiesArgs].
 */
@PulumiTagMarker
public class LabelingJobImagePropertiesArgsBuilder internal constructor() {
    private var annotationType: Output<Either<String, ImageAnnotationType>>? = null

    private var mediaType: Output<String>? = null

    /**
     * @param value Annotation type of image labeling job.
     */
    @JvmName("jnfyotlnxxpllkvn")
    public suspend fun annotationType(`value`: Output<Either<String, ImageAnnotationType>>) {
        this.annotationType = value
    }

    /**
     * @param value Media type of data asset.
     * Expected value is 'Image'.
     */
    @JvmName("msdfsnohrebpxuoq")
    public suspend fun mediaType(`value`: Output<String>) {
        this.mediaType = value
    }

    /**
     * @param value Annotation type of image labeling job.
     */
    @JvmName("vpcnpcqobdxbbnwg")
    public suspend fun annotationType(`value`: Either<String, ImageAnnotationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotationType = mapped
    }

    /**
     * @param value Annotation type of image labeling job.
     */
    @JvmName("tbergchmeqeepynj")
    public fun annotationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ImageAnnotationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotationType = mapped
    }

    /**
     * @param value Annotation type of image labeling job.
     */
    @JvmName("deqcegshdranojky")
    public fun annotationType(`value`: ImageAnnotationType) {
        val toBeMapped = Either.ofRight<String, ImageAnnotationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotationType = mapped
    }

    /**
     * @param value Media type of data asset.
     * Expected value is 'Image'.
     */
    @JvmName("mmcehdtxnnxyrqwm")
    public suspend fun mediaType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mediaType = mapped
    }

    internal fun build(): LabelingJobImagePropertiesArgs = LabelingJobImagePropertiesArgs(
        annotationType = annotationType,
        mediaType = mediaType ?: throw PulumiNullFieldException("mediaType"),
    )
}
