@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobTextPropertiesArgs.builder
import com.pulumi.azurenative.machinelearningservices.kotlin.enums.TextAnnotationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a labeling job for text data
 * @property annotationType Annotation type of text labeling job.
 * @property mediaType Media type of data asset.
 * Expected value is 'Text'.
 */
public data class LabelingJobTextPropertiesArgs(
    public val annotationType: Output<Either<String, TextAnnotationType>>? = null,
    public val mediaType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobTextPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobTextPropertiesArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LabelingJobTextPropertiesArgs.builder()
            .annotationType(
                annotationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .mediaType(mediaType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabelingJobTextPropertiesArgs].
 */
@PulumiTagMarker
public class LabelingJobTextPropertiesArgsBuilder internal constructor() {
    private var annotationType: Output<Either<String, TextAnnotationType>>? = null

    private var mediaType: Output<String>? = null

    /**
     * @param value Annotation type of text labeling job.
     */
    @JvmName("qptlkaxshmwhipau")
    public suspend fun annotationType(`value`: Output<Either<String, TextAnnotationType>>) {
        this.annotationType = value
    }

    /**
     * @param value Media type of data asset.
     * Expected value is 'Text'.
     */
    @JvmName("wfbrmopqvujoswcv")
    public suspend fun mediaType(`value`: Output<String>) {
        this.mediaType = value
    }

    /**
     * @param value Annotation type of text labeling job.
     */
    @JvmName("qmvgkmsdvvnlhnad")
    public suspend fun annotationType(`value`: Either<String, TextAnnotationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotationType = mapped
    }

    /**
     * @param value Annotation type of text labeling job.
     */
    @JvmName("gvkrrqvlxqeoeuqu")
    public fun annotationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TextAnnotationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotationType = mapped
    }

    /**
     * @param value Annotation type of text labeling job.
     */
    @JvmName("lsadtehctcadjelp")
    public fun annotationType(`value`: TextAnnotationType) {
        val toBeMapped = Either.ofRight<String, TextAnnotationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotationType = mapped
    }

    /**
     * @param value Media type of data asset.
     * Expected value is 'Text'.
     */
    @JvmName("wbpxpsillkginkua")
    public suspend fun mediaType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mediaType = mapped
    }

    internal fun build(): LabelingJobTextPropertiesArgs = LabelingJobTextPropertiesArgs(
        annotationType = annotationType,
        mediaType = mediaType ?: throw PulumiNullFieldException("mediaType"),
    )
}
