@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.machinelearningservices.kotlin.inputs

import com.pulumi.azurenative.machinelearningservices.inputs.LinkedWorkspacePropsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * LinkedWorkspace specific properties.
 * @property linkedWorkspaceResourceId ResourceId of the link target of the linked workspace.
 * @property userAssignedIdentityResourceId ResourceId of the user assigned identity for the linked workspace.
 */
public data class LinkedWorkspacePropsArgs(
    public val linkedWorkspaceResourceId: Output<String>? = null,
    public val userAssignedIdentityResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.machinelearningservices.inputs.LinkedWorkspacePropsArgs> {
    override fun toJava():
        com.pulumi.azurenative.machinelearningservices.inputs.LinkedWorkspacePropsArgs =
        com.pulumi.azurenative.machinelearningservices.inputs.LinkedWorkspacePropsArgs.builder()
            .linkedWorkspaceResourceId(linkedWorkspaceResourceId?.applyValue({ args0 -> args0 }))
            .userAssignedIdentityResourceId(
                userAssignedIdentityResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [LinkedWorkspacePropsArgs].
 */
@PulumiTagMarker
public class LinkedWorkspacePropsArgsBuilder internal constructor() {
    private var linkedWorkspaceResourceId: Output<String>? = null

    private var userAssignedIdentityResourceId: Output<String>? = null

    /**
     * @param value ResourceId of the link target of the linked workspace.
     */
    @JvmName("ckddvxosxhhkciel")
    public suspend fun linkedWorkspaceResourceId(`value`: Output<String>) {
        this.linkedWorkspaceResourceId = value
    }

    /**
     * @param value ResourceId of the user assigned identity for the linked workspace.
     */
    @JvmName("pbphdcklfiqiyhrc")
    public suspend fun userAssignedIdentityResourceId(`value`: Output<String>) {
        this.userAssignedIdentityResourceId = value
    }

    /**
     * @param value ResourceId of the link target of the linked workspace.
     */
    @JvmName("vnjcpkumwxvcaind")
    public suspend fun linkedWorkspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedWorkspaceResourceId = mapped
    }

    /**
     * @param value ResourceId of the user assigned identity for the linked workspace.
     */
    @JvmName("vutemxrlhiyktyve")
    public suspend fun userAssignedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentityResourceId = mapped
    }

    internal fun build(): LinkedWorkspacePropsArgs = LinkedWorkspacePropsArgs(
        linkedWorkspaceResourceId = linkedWorkspaceResourceId,
        userAssignedIdentityResourceId = userAssignedIdentityResourceId,
    )
}
